/*
 * Decompiled with CFR 0.152.
 */
package org.spigotmc;

import java.util.List;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.boss.WitherEntity;
import net.minecraft.entity.boss.dragon.EnderDragonEntity;
import net.minecraft.entity.boss.dragon.EnderDragonPartEntity;
import net.minecraft.entity.effect.LightningBoltEntity;
import net.minecraft.entity.item.EnderCrystalEntity;
import net.minecraft.entity.item.TNTEntity;
import net.minecraft.entity.merchant.villager.VillagerEntity;
import net.minecraft.entity.monster.AbstractRaiderEntity;
import net.minecraft.entity.monster.CreeperEntity;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.monster.SlimeEntity;
import net.minecraft.entity.passive.AmbientEntity;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.passive.SheepEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.entity.projectile.DamagingProjectileEntity;
import net.minecraft.entity.projectile.FireworkRocketEntity;
import net.minecraft.entity.projectile.ThrowableEntity;
import net.minecraft.entity.projectile.TridentEntity;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import org.bukkit.craftbukkit.v1_16_R3.SpigotTimings;
import org.spigotmc.SpigotWorldConfig;

public class ActivationRange {
    static AxisAlignedBB maxBB = new AxisAlignedBB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);

    public static ActivationType initializeEntityActivationType(Entity entity) {
        if (entity instanceof AbstractRaiderEntity) {
            return ActivationType.RAIDER;
        }
        if (entity instanceof MonsterEntity || entity instanceof SlimeEntity) {
            return ActivationType.MONSTER;
        }
        if (entity instanceof CreatureEntity || entity instanceof AmbientEntity) {
            return ActivationType.ANIMAL;
        }
        return ActivationType.MISC;
    }

    public static boolean initializeEntityActivationState(Entity entity, SpigotWorldConfig config) {
        return entity.activationType == ActivationType.MISC && config.miscActivationRange == 0 || entity.activationType == ActivationType.RAIDER && config.raiderActivationRange == 0 || entity.activationType == ActivationType.ANIMAL && config.animalActivationRange == 0 || entity.activationType == ActivationType.MONSTER && config.monsterActivationRange == 0 || entity instanceof PlayerEntity || entity instanceof ThrowableEntity || entity instanceof EnderDragonEntity || entity instanceof EnderDragonPartEntity || entity instanceof WitherEntity || entity instanceof DamagingProjectileEntity || entity instanceof LightningBoltEntity || entity instanceof TNTEntity || entity instanceof EnderCrystalEntity || entity instanceof FireworkRocketEntity || entity instanceof TridentEntity;
    }

    public static void activateEntities(World world) {
        SpigotTimings.entityActivationCheckTimer.startTiming();
        int miscActivationRange = world.spigotConfig.miscActivationRange;
        int raiderActivationRange = world.spigotConfig.raiderActivationRange;
        int animalActivationRange = world.spigotConfig.animalActivationRange;
        int monsterActivationRange = world.spigotConfig.monsterActivationRange;
        int maxRange = Math.max(monsterActivationRange, animalActivationRange);
        maxRange = Math.max(maxRange, raiderActivationRange);
        maxRange = Math.max(maxRange, miscActivationRange);
        maxRange = Math.min((world.spigotConfig.viewDistance << 4) - 8, maxRange);
        for (PlayerEntity player : world.func_217369_A()) {
            player.activatedTick = MinecraftServer.currentTick;
            maxBB = player.func_174813_aQ().func_72314_b((double)maxRange, 256.0, (double)maxRange);
            ActivationType.MISC.boundingBox = player.func_174813_aQ().func_72314_b((double)miscActivationRange, 256.0, (double)miscActivationRange);
            ActivationType.RAIDER.boundingBox = player.func_174813_aQ().func_72314_b((double)raiderActivationRange, 256.0, (double)raiderActivationRange);
            ActivationType.ANIMAL.boundingBox = player.func_174813_aQ().func_72314_b((double)animalActivationRange, 256.0, (double)animalActivationRange);
            ActivationType.MONSTER.boundingBox = player.func_174813_aQ().func_72314_b((double)monsterActivationRange, 256.0, (double)monsterActivationRange);
            int i = MathHelper.func_76128_c((double)(ActivationRange.maxBB.field_72340_a / 16.0));
            int j = MathHelper.func_76128_c((double)(ActivationRange.maxBB.field_72336_d / 16.0));
            int k = MathHelper.func_76128_c((double)(ActivationRange.maxBB.field_72339_c / 16.0));
            int l = MathHelper.func_76128_c((double)(ActivationRange.maxBB.field_72334_f / 16.0));
            int i1 = i;
            while (i1 <= j) {
                int j1 = k;
                while (j1 <= l) {
                    if (world.getWorld().isChunkLoaded(i1, j1)) {
                        ActivationRange.activateChunkEntities(world.func_212866_a_(i1, j1));
                    }
                    ++j1;
                }
                ++i1;
            }
        }
        SpigotTimings.entityActivationCheckTimer.stopTiming();
    }

    private static void activateChunkEntities(Chunk chunk) {
        List[] listArray = chunk.field_76645_j;
        int n = chunk.field_76645_j.length;
        int n2 = 0;
        while (n2 < n) {
            List slice = listArray[n2];
            for (Entity entity : slice) {
                if ((long)MinecraftServer.currentTick <= entity.activatedTick) continue;
                if (entity.defaultActivationState) {
                    entity.activatedTick = MinecraftServer.currentTick;
                    continue;
                }
                if (!entity.activationType.boundingBox.func_72326_a(entity.func_174813_aQ())) continue;
                entity.activatedTick = MinecraftServer.currentTick;
            }
            ++n2;
        }
    }

    public static boolean checkEntityImmunities(Entity entity) {
        if (entity.field_70171_ac || entity.field_190534_ay > 0) {
            return true;
        }
        if (!(entity instanceof AbstractArrowEntity) ? !entity.func_233570_aj_() || !entity.field_184244_h.isEmpty() || entity.func_184218_aH() : !((AbstractArrowEntity)entity).field_70254_i) {
            return true;
        }
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            if (living.field_70737_aN > 0 || living.field_70713_bf.size() > 0) {
                return true;
            }
            if (entity instanceof CreatureEntity && ((CreatureEntity)entity).func_70638_az() != null) {
                return true;
            }
            if (entity instanceof VillagerEntity && ((VillagerEntity)entity).func_213743_em()) {
                return true;
            }
            if (entity instanceof AnimalEntity) {
                AnimalEntity animal = (AnimalEntity)entity;
                if (animal.func_70631_g_() || animal.func_70880_s()) {
                    return true;
                }
                if (entity instanceof SheepEntity && ((SheepEntity)entity).func_70892_o()) {
                    return true;
                }
            }
            if (entity instanceof CreeperEntity && ((CreeperEntity)entity).func_146078_ca()) {
                return true;
            }
        }
        return false;
    }

    public static boolean checkIfActive(Entity entity) {
        boolean isActive;
        SpigotTimings.checkIfActiveTimer.startTiming();
        if (!entity.field_70175_ag || entity instanceof FireworkRocketEntity) {
            SpigotTimings.checkIfActiveTimer.stopTiming();
            return true;
        }
        boolean bl = isActive = entity.activatedTick >= (long)MinecraftServer.currentTick || entity.defaultActivationState;
        if (!isActive) {
            if (((long)MinecraftServer.currentTick - entity.activatedTick - 1L) % 20L == 0L) {
                if (ActivationRange.checkEntityImmunities(entity)) {
                    entity.activatedTick = MinecraftServer.currentTick + 20;
                }
                isActive = true;
            }
        } else if (!entity.defaultActivationState && entity.field_70173_aa % 4 == 0 && !ActivationRange.checkEntityImmunities(entity)) {
            isActive = false;
        }
        SpigotTimings.checkIfActiveTimer.stopTiming();
        return isActive;
    }

    public static enum ActivationType {
        MONSTER,
        ANIMAL,
        RAIDER,
        MISC;

        public AxisAlignedBB boundingBox = new AxisAlignedBB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
    }
}

