/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.defaultoptions;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import net.minecraft.client.Minecraft;
import org.apache.commons.io.FileUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DefaultOptionsInitializer {
    public static final Logger logger = LogManager.getLogger((String)"defaultoptions");

    public static File getDefaultOptionsFolder() {
        File defaultOptions = new File(DefaultOptionsInitializer.getMinecraftDataDir(), "config/defaultoptions");
        if (!defaultOptions.exists() && !defaultOptions.mkdirs()) {
            throw new IllegalStateException("Could not create default options directory.");
        }
        return defaultOptions;
    }

    public static File getMinecraftDataDir() {
        return Minecraft.func_71410_x().field_71412_D;
    }

    public static void applyDefaults() {
        File serversDatFile;
        File optionsFileOF;
        boolean firstRun;
        File mcDataDir = DefaultOptionsInitializer.getMinecraftDataDir();
        File optionsFile = new File(mcDataDir, "options.txt");
        boolean bl = firstRun = !optionsFile.exists();
        if (firstRun) {
            DefaultOptionsInitializer.applyDefaultOptions();
        }
        if (!(optionsFileOF = new File(mcDataDir, "optionsof.txt")).exists()) {
            DefaultOptionsInitializer.applyDefaultOptionsOptifine();
        }
        if (!(serversDatFile = new File(mcDataDir, "servers.dat")).exists()) {
            DefaultOptionsInitializer.applyDefaultServers();
        }
    }

    private static void applyDefaultServers() {
        try {
            FileUtils.copyFile((File)new File(DefaultOptionsInitializer.getDefaultOptionsFolder(), "servers.dat"), (File)new File(DefaultOptionsInitializer.getMinecraftDataDir(), "servers.dat"));
        }
        catch (IOException e) {
            logger.error((Object)e);
        }
    }

    private static boolean applyDefaultOptions() {
        File defaultOptionsFile = new File(DefaultOptionsInitializer.getDefaultOptionsFolder(), "options.txt");
        if (defaultOptionsFile.exists()) {
            try (BufferedReader reader = new BufferedReader(new FileReader(defaultOptionsFile));
                 PrintWriter writer = new PrintWriter(new FileWriter(new File(DefaultOptionsInitializer.getMinecraftDataDir(), "options.txt")));){
                String line;
                while ((line = reader.readLine()) != null) {
                    if (line.startsWith("key_")) continue;
                    writer.println(line);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                return false;
            }
        }
        return true;
    }

    private static void applyDefaultOptionsOptifine() {
        File defaultOptionsFile = new File(DefaultOptionsInitializer.getDefaultOptionsFolder(), "optionsof.txt");
        if (defaultOptionsFile.exists()) {
            try (BufferedReader reader = new BufferedReader(new FileReader(defaultOptionsFile));
                 PrintWriter writer = new PrintWriter(new FileWriter(new File(DefaultOptionsInitializer.getMinecraftDataDir(), "optionsof.txt")));){
                String line;
                while ((line = reader.readLine()) != null) {
                    writer.println(line);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

