/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.core.capability;

import com.craftingdead.core.capability.SimpleCapabilityProvider;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.nbt.INBT;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.common.util.NonNullFunction;

public class SerializableCapabilityProvider<C extends INBTSerializable<S>, S extends INBT>
extends SimpleCapabilityProvider<C>
implements INBTSerializable<S> {
    private final Supplier<S> emptyNbt;

    public SerializableCapabilityProvider(LazyOptional<C> capability, Supplier<Capability<? super C>> capabilityHolder, Supplier<S> emptyNbt) {
        super(capability, ImmutableSet.of(capabilityHolder));
        this.emptyNbt = emptyNbt;
    }

    public SerializableCapabilityProvider(LazyOptional<C> capability, Set<Supplier<Capability<? super C>>> capabilityHolder, Supplier<S> emptyNbt) {
        super(capability, capabilityHolder, null);
        this.emptyNbt = emptyNbt;
    }

    public SerializableCapabilityProvider(LazyOptional<C> instance, Set<Supplier<Capability<? super C>>> capabilities, NonNullFunction<C, ICapabilityProvider> instanceMapper, Supplier<S> emptyNbt) {
        super(instance, capabilities, instanceMapper);
        this.emptyNbt = emptyNbt;
    }

    public S serializeNBT() {
        return (S)((INBT)this.instance.map(INBTSerializable::serializeNBT).orElseGet(this.emptyNbt));
    }

    public void deserializeNBT(S nbt) {
        this.instance.ifPresent(i -> i.deserializeNBT(nbt));
    }
}

