/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.core.client.renderer.item;

import com.craftingdead.core.client.renderer.item.GunRenderer;
import com.craftingdead.core.client.renderer.item.model.ModelPistolIS2;
import com.craftingdead.core.client.renderer.item.model.ModelScarhIS1;
import com.craftingdead.core.world.gun.Gun;
import com.craftingdead.core.world.gun.attachment.Attachment;
import com.craftingdead.core.world.gun.attachment.Attachments;
import com.craftingdead.core.world.gun.type.GunTypes;
import com.craftingdead.core.world.item.ModItems;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.model.Model;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3f;

public class AWPRenderer
extends GunRenderer {
    private final Model ironSight1 = new ModelScarhIS1();
    private final Model ironSight2 = new ModelPistolIS2();

    public AWPRenderer() {
        super(ModItems.AWP.getId(), GunTypes.AWP);
    }

    @Override
    protected void applyGenericTransforms(Gun gun, MatrixStack matrixStack) {
        matrixStack.func_227862_a_(1.5f, 1.5f, 1.5f);
        matrixStack.func_227861_a_(-0.7, -0.2, 0.0);
    }

    @Override
    protected void applyThirdPersonTransforms(Gun gun, MatrixStack matrixStack) {
        matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(180.0f));
        matrixStack.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(-15.0f));
        matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(77.0f));
        matrixStack.func_227861_a_(0.5, -0.75, (double)0.35f);
        matrixStack.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(15.0f));
        matrixStack.func_227861_a_((double)-0.4f, (double)0.55f, 0.0);
        float scale = 1.15f;
        matrixStack.func_227862_a_(scale, scale, scale);
    }

    @Override
    protected void applyFirstPersonTransforms(Gun gun, MatrixStack matrixStack) {
        this.muzzleFlashX = 0.3f;
        this.muzzleFlashY = -0.1f;
        this.muzzleFlashZ = -2.0f;
        this.muzzleScale = 2.0f;
        matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(180.0f));
        matrixStack.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(-38.0f));
        matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(-5.0f));
        matrixStack.func_227861_a_((double)0.4f, (double)-0.2f, (double)0.2f);
        float scale = 0.75f;
        matrixStack.func_227862_a_(scale, scale, scale);
    }

    @Override
    protected void applyAimingTransforms(Gun gun, MatrixStack matrixStack) {
        matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(180.0f));
        matrixStack.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(-24.0f));
        matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(5.1f));
        matrixStack.func_227861_a_((double)0.15f, (double)-0.679f, (double)0.97f);
        if (!gun.hasIronSight()) {
            matrixStack.func_227861_a_(0.0, (double)0.022f, 0.0);
        }
        float scale = 0.6f;
        matrixStack.func_227862_a_(scale, scale, scale);
        matrixStack.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(-0.7f));
    }

    @Override
    protected void renderAdditionalParts(Gun gun, float partialTicks, MatrixStack matrixStack, IRenderTypeBuffer renderTypeBuffer, int packedLight, int packedOverlay) {
        this.renderIronSight1(matrixStack, renderTypeBuffer, packedLight, packedOverlay);
        this.renderIronSight2(matrixStack, renderTypeBuffer, packedLight, packedOverlay);
    }

    @Override
    protected void applyWearingTransforms(Gun gun, MatrixStack matrixStack) {
        matrixStack.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(90.0f));
        matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(90.0f));
        matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(180.0f));
        float scale = 0.65f;
        matrixStack.func_227862_a_(scale, scale, scale);
        matrixStack.func_227861_a_((double)-0.7f, (double)0.2f, (double)0.3f);
    }

    private void renderIronSight1(MatrixStack matrixStack, IRenderTypeBuffer renderTypeBuffer, int packedLight, int packedOverlay) {
        matrixStack.func_227860_a_();
        matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(180.0f));
        float scale = 0.5f;
        matrixStack.func_227862_a_(scale, scale, scale);
        matrixStack.func_227861_a_((double)1.2f, (double)-0.525f, (double)-0.07f);
        scale = 0.75f;
        matrixStack.func_227862_a_(scale, scale, scale);
        matrixStack.func_227861_a_(-2.0, (double)0.6f, (double)-0.14f);
        IVertexBuilder vertexBuilder = renderTypeBuffer.getBuffer(this.ironSight1.func_228282_a_(new ResourceLocation("craftingdead", "textures/attachment/scarh_is1.png")));
        this.ironSight1.func_225598_a_(matrixStack, vertexBuilder, packedLight, packedOverlay, 1.0f, 1.0f, 1.0f, 1.0f);
        matrixStack.func_227865_b_();
    }

    private void renderIronSight2(MatrixStack matrixStack, IRenderTypeBuffer renderTypeBuffer, int packedLight, int packedOverlay) {
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_((double)1.7f, (double)-0.09f, (double)0.059f);
        float scale = 0.25f;
        matrixStack.func_227862_a_(scale, scale + 0.5f, scale);
        IVertexBuilder vertexBuilder = renderTypeBuffer.getBuffer(this.ironSight2.func_228282_a_(new ResourceLocation("craftingdead", "textures/attachment/m1911_is2.png")));
        this.ironSight2.func_225598_a_(matrixStack, vertexBuilder, packedLight, packedOverlay, 1.0f, 1.0f, 1.0f, 1.0f);
        matrixStack.func_227865_b_();
    }

    @Override
    protected void applyMagazineTransforms(ItemStack itemStack, MatrixStack matrixStack) {
    }

    @Override
    protected void applyAttachmentTransforms(Attachment attachment, MatrixStack matrixStack) {
        if (attachment == Attachments.LP_SCOPE.get()) {
            matrixStack.func_227861_a_(2.0, -1.6, 0.25);
            float scale = 0.6f;
            matrixStack.func_227862_a_(scale, scale, scale);
            return;
        }
        if (attachment == Attachments.HP_SCOPE.get()) {
            matrixStack.func_227861_a_(2.0, -1.6, 0.25);
            float scale = 0.6f;
            matrixStack.func_227862_a_(scale, scale, scale);
            return;
        }
        if (attachment == Attachments.BIPOD.get()) {
            matrixStack.func_227861_a_(7.0, 1.1, 0.07);
            float scale = 0.85f;
            matrixStack.func_227862_a_(scale, scale, scale);
            return;
        }
        if (attachment == Attachments.SUPPRESSOR.get()) {
            matrixStack.func_227861_a_(21.3, -0.53, 1.1);
            float scale = 0.7f;
            matrixStack.func_227862_a_(scale, scale, scale);
        }
    }

    @Override
    protected void applyHandTransforms(Gun gun, boolean rightHand, MatrixStack matrixStack) {
        if (rightHand) {
            matrixStack.func_227861_a_((double)-0.1f, (double)-0.15f, (double)-0.3f);
        } else {
            matrixStack.func_227861_a_((double)0.01f, (double)0.15f, (double)-0.1f);
        }
    }

    @Override
    protected void applySprintingTransforms(MatrixStack matrixStack, float pct) {
        matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(pct * -50.0f));
        matrixStack.func_227861_a_((double)(pct * 0.6f), 0.0, (double)(pct * 0.1f));
    }
}

