/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.core.client.renderer.item;

import com.craftingdead.core.client.renderer.item.GunRenderer;
import com.craftingdead.core.client.renderer.item.model.ModelMinigunBarrel;
import com.craftingdead.core.world.gun.Gun;
import com.craftingdead.core.world.gun.attachment.Attachment;
import com.craftingdead.core.world.gun.type.GunTypes;
import com.craftingdead.core.world.gun.type.minigun.MinigunClient;
import com.craftingdead.core.world.item.ModItems;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.model.Model;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3f;

public class MinigunRenderer
extends GunRenderer {
    private final Model barrelModel = new ModelMinigunBarrel();

    public MinigunRenderer() {
        super(ModItems.MINIGUN.getId(), GunTypes.MINIGUN);
    }

    @Override
    protected void applyGenericTransforms(Gun gun, MatrixStack matrixStack) {
        matrixStack.func_227862_a_(1.2f, 1.2f, 1.2f);
        matrixStack.func_227861_a_((double)-0.8f, (double)-0.15f, 0.0);
    }

    @Override
    protected void applyThirdPersonTransforms(Gun gun, MatrixStack matrixStack) {
        matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(190.0f));
        matrixStack.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(-15.0f));
        matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(80.0f));
        matrixStack.func_227861_a_(0.0, 0.25, 0.25);
        matrixStack.func_227861_a_((double)-0.8f, (double)-0.1f, 0.0);
        matrixStack.func_227861_a_((double)0.3f, (double)0.3f, (double)0.2f);
        float scale = 1.4f;
        matrixStack.func_227862_a_(scale, scale, scale);
    }

    @Override
    protected void applyFirstPersonTransforms(Gun gun, MatrixStack matrixStack) {
        this.muzzleFlashX = 0.2f;
        this.muzzleFlashY = -0.43f;
        this.muzzleFlashZ = -1.8f;
        this.muzzleScale = 2.0f;
        matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(180.0f));
        matrixStack.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(-40.0f));
        matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(-3.0f));
        matrixStack.func_227861_a_((double)0.1f, 0.5, (double)-0.1f);
        float scale = 1.3f;
        matrixStack.func_227862_a_(scale, scale, scale);
        matrixStack.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(3.0f));
    }

    @Override
    protected void applyAimingTransforms(Gun gun, MatrixStack matrixStack) {
        matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(180.0f));
        matrixStack.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(-24.0f));
        matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(5.1f));
        matrixStack.func_227861_a_((double)-0.1f, (double)-0.665f, (double)0.952f);
        float scale = 0.6f;
        matrixStack.func_227862_a_(scale, scale, scale);
        matrixStack.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(-0.7f));
    }

    @Override
    protected void renderAdditionalParts(Gun gun, float partialTicks, MatrixStack matrixStack, IRenderTypeBuffer renderTypeBuffer, int packedLight, int packedOverlay) {
        if (gun.getClient() instanceof MinigunClient) {
            this.renderBarrel(((MinigunClient)gun.getClient()).getBarrelRotation(partialTicks), partialTicks, matrixStack, renderTypeBuffer, packedLight, packedOverlay);
        }
    }

    private void renderBarrel(float rotation, float partialTicks, MatrixStack matrixStack, IRenderTypeBuffer renderTypeBuffer, int packedLight, int packedOverlay) {
        matrixStack.func_227860_a_();
        float x = 0.155f;
        float y = 0.035f;
        matrixStack.func_227861_a_(0.0, (double)0.155f, (double)-0.035f);
        matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(rotation));
        matrixStack.func_227861_a_(0.0, (double)-0.155f, (double)0.035f);
        IVertexBuilder vertexBuilder = renderTypeBuffer.getBuffer(this.barrelModel.func_228282_a_(new ResourceLocation("craftingdead", "textures/gun/minigun.png")));
        this.barrelModel.func_225598_a_(matrixStack, vertexBuilder, packedLight, packedOverlay, 1.0f, 1.0f, 1.0f, 1.0f);
        matrixStack.func_227865_b_();
    }

    @Override
    protected void applyWearingTransforms(Gun gun, MatrixStack matrixStack) {
        matrixStack.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(90.0f));
        matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(90.0f));
        matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(180.0f));
        float scale = 0.8f;
        matrixStack.func_227862_a_(scale, scale, scale);
        matrixStack.func_227861_a_((double)-0.8f, (double)0.2f, (double)0.4f);
    }

    @Override
    protected void applyMagazineTransforms(ItemStack itemStack, MatrixStack matrixStack) {
    }

    @Override
    protected void applyAttachmentTransforms(Attachment attachment, MatrixStack matrixStack) {
    }

    @Override
    protected void applyHandTransforms(Gun gun, boolean rightHand, MatrixStack matrixStack) {
        if (rightHand) {
            matrixStack.func_227861_a_((double)-0.1f, (double)-0.15f, (double)-0.3f);
        } else {
            matrixStack.func_227861_a_((double)0.01f, (double)0.15f, (double)-0.1f);
        }
    }

    @Override
    protected void applySprintingTransforms(MatrixStack matrixStack, float pct) {
        matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(pct * -50.0f));
        matrixStack.func_227861_a_((double)(pct * 0.3f), 0.0, (double)(pct * 0.1f));
    }
}

