/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.core.network;

import java.util.Optional;
import net.minecraft.entity.Entity;
import net.minecraftforge.fml.LogicalSidedProvider;
import net.minecraftforge.fml.network.NetworkEvent;

public class NetworkUtil {
    public static Entity getEntityOrSender(NetworkEvent.Context context, int entityId) {
        return NetworkUtil.getEntityOrSender(context, entityId, Entity.class);
    }

    public static <T extends Entity> T getEntityOrSender(NetworkEvent.Context context, int entityId, Class<T> clazz) {
        switch (context.getDirection().getReceptionSide()) {
            case CLIENT: {
                return NetworkUtil.getEntity(context, entityId, clazz);
            }
            case SERVER: {
                if (clazz.isInstance(context.getSender())) {
                    return (T)((Entity)clazz.cast(context.getSender()));
                }
                throw new IllegalStateException("Sender is not instance of: " + clazz.getName());
            }
        }
        throw new IllegalStateException("Invalid side");
    }

    public static Entity getEntity(NetworkEvent.Context context, int entityId) {
        return NetworkUtil.getEntity(context, entityId, Entity.class);
    }

    public static <T extends Entity> T getEntity(NetworkEvent.Context context, int entityId, Class<T> clazz) {
        return (T)((Optional)LogicalSidedProvider.CLIENTWORLD.get(context.getDirection().getReceptionSide())).map(level -> level.func_73045_a(entityId)).filter(clazz::isInstance).map(clazz::cast).orElseThrow(() -> new IllegalStateException(String.format("Entity with ID %s of type %s is absent from client level", entityId, clazz.getName())));
    }
}

