/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.core.network.message.play;

import com.craftingdead.core.capability.Capabilities;
import com.craftingdead.core.network.NetworkUtil;
import com.craftingdead.core.world.action.ActionType;
import com.craftingdead.core.world.entity.extension.LivingExtension;
import java.util.function.Supplier;
import net.minecraft.entity.LivingEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class PerformActionMessage {
    private final ActionType actionType;
    private final int performerEntityId;
    private final int targetEntityId;

    public PerformActionMessage(ActionType actionType, int performerEntityId, int targetEntityId) {
        this.actionType = actionType;
        this.performerEntityId = performerEntityId;
        this.targetEntityId = targetEntityId;
    }

    public void encode(PacketBuffer out) {
        out.writeRegistryId((IForgeRegistryEntry)this.actionType);
        out.func_150787_b(this.performerEntityId);
        out.func_150787_b(this.targetEntityId);
    }

    public static PerformActionMessage decode(PacketBuffer in) {
        return new PerformActionMessage((ActionType)in.readRegistryId(), in.func_150792_a(), in.func_150792_a());
    }

    public boolean handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            LivingEntity performerEntity = NetworkUtil.getEntityOrSender((NetworkEvent.Context)ctx.get(), this.performerEntityId, LivingEntity.class);
            LivingExtension<LivingEntity, ?> performer = LivingExtension.getOrThrow(performerEntity);
            LivingExtension target = this.targetEntityId == -1 ? null : (LivingExtension)performerEntity.field_70170_p.func_73045_a(this.targetEntityId).getCapability(Capabilities.LIVING_EXTENSION).orElse(null);
            boolean serverSide = ((NetworkEvent.Context)ctx.get()).getDirection().getReceptionSide().isServer();
            if (!serverSide || this.actionType.isTriggeredByClient()) {
                performer.performAction(this.actionType.createAction(performer, target), serverSide);
            }
        });
        return true;
    }
}

