/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.core.network.message.play;

import com.craftingdead.core.capability.Capabilities;
import com.craftingdead.core.network.NetworkUtil;
import com.craftingdead.core.world.gun.Gun;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.function.Supplier;
import net.minecraft.entity.LivingEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;

public class SyncGunEquipmentSlotMessage {
    private final int entityId;
    private final EquipmentSlotType slot;
    private final PacketBuffer data;

    public SyncGunEquipmentSlotMessage(int entityId, EquipmentSlotType slot, Gun gun, boolean writeAll) {
        this(entityId, slot, new PacketBuffer(Unpooled.buffer()));
        gun.encode(this.data, writeAll);
    }

    public SyncGunEquipmentSlotMessage(int entityId, EquipmentSlotType slot, PacketBuffer data) {
        this.entityId = entityId;
        this.slot = slot;
        this.data = data;
    }

    public void encode(PacketBuffer out) {
        out.func_150787_b(this.entityId);
        out.func_179249_a((Enum)this.slot);
        out.func_150787_b(this.data.readableBytes());
        out.writeBytes((ByteBuf)this.data);
    }

    public static SyncGunEquipmentSlotMessage decode(PacketBuffer in) {
        int entityId = in.func_150792_a();
        EquipmentSlotType slot = (EquipmentSlotType)in.func_179257_a(EquipmentSlotType.class);
        byte[] data = new byte[in.func_150792_a()];
        in.readBytes(data);
        return new SyncGunEquipmentSlotMessage(entityId, slot, new PacketBuffer(Unpooled.wrappedBuffer((byte[])data)));
    }

    public boolean handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> NetworkUtil.getEntity((NetworkEvent.Context)ctx.get(), this.entityId, LivingEntity.class).func_184582_a(this.slot).getCapability(Capabilities.GUN).ifPresent(gun -> gun.decode(this.data)));
        return true;
    }
}

