/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.core.network.message.play;

import com.craftingdead.core.capability.Capabilities;
import com.craftingdead.core.network.NetworkUtil;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.function.Supplier;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;

public class SyncLivingMessage {
    private final int entityId;
    private final PacketBuffer data;

    public SyncLivingMessage(int entityId, PacketBuffer data) {
        this.entityId = entityId;
        this.data = data;
    }

    public void encode(PacketBuffer out) {
        out.func_150787_b(this.entityId);
        out.func_150787_b(this.data.readableBytes());
        out.writeBytes((ByteBuf)this.data);
    }

    public static SyncLivingMessage decode(PacketBuffer in) {
        int entityId = in.func_150792_a();
        byte[] data = new byte[in.func_150792_a()];
        in.readBytes(data);
        SyncLivingMessage msg = new SyncLivingMessage(entityId, new PacketBuffer(Unpooled.wrappedBuffer((byte[])data)));
        return msg;
    }

    public boolean handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> NetworkUtil.getEntity((NetworkEvent.Context)ctx.get(), this.entityId).getCapability(Capabilities.LIVING_EXTENSION).ifPresent(living -> living.decode(this.data)));
        return true;
    }
}

