/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.core.world.action;

import com.craftingdead.core.world.action.AbstractAction;
import com.craftingdead.core.world.action.ActionType;
import com.craftingdead.core.world.entity.extension.LivingExtension;
import javax.annotation.Nullable;

public abstract class TimedAction<T extends ActionType>
extends AbstractAction<T> {
    private int durationTicks;

    public TimedAction(T type, LivingExtension<?, ?> performer, @Nullable LivingExtension<?, ?> target) {
        super(type, performer, target);
    }

    protected abstract int getTotalDurationTicks();

    @Override
    public boolean start() {
        if (this.getTotalDurationTicks() <= 0) {
            this.finish();
            return false;
        }
        return true;
    }

    @Override
    public boolean tick() {
        if (++this.durationTicks >= this.getTotalDurationTicks()) {
            this.finish();
            return true;
        }
        return false;
    }

    protected abstract void finish();

    @Override
    public void cancel() {
        this.durationTicks = 0;
    }

    @Override
    public float getProgress(float partialTicks) {
        return ((float)this.durationTicks + partialTicks) / (float)this.getTotalDurationTicks();
    }
}

