/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.core.world.action.delegated;

import com.craftingdead.core.util.RayTraceUtil;
import com.craftingdead.core.world.action.delegated.AbstractDelegatedAction;
import com.craftingdead.core.world.action.delegated.DelegatedEntityActionType;
import com.craftingdead.core.world.entity.extension.LivingExtension;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.math.EntityRayTraceResult;
import org.apache.commons.lang3.tuple.Pair;

public final class DelegatedEntityAction
extends AbstractDelegatedAction<DelegatedEntityActionType> {
    private final LivingExtension<?, ?> selectedTarget;

    DelegatedEntityAction(DelegatedEntityActionType type, LivingExtension<?, ?> selectedTarget) {
        super(type);
        this.selectedTarget = selectedTarget;
    }

    @Override
    public boolean canPerform(LivingExtension<?, ?> performer, @Nullable LivingExtension<?, ?> target, ItemStack heldStack) {
        if (!((DelegatedEntityActionType)this.type).getCondition().getAsBoolean()) {
            return false;
        }
        if (!performer.getLevel().func_201670_d()) {
            Optional<EntityRayTraceResult> entityRayTraceResult = RayTraceUtil.rayTraceEntities(performer.getEntity());
            if (this.selectedTarget != performer && this.selectedTarget.getEntity() != entityRayTraceResult.map(EntityRayTraceResult::func_216348_a).orElse(null)) {
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean finish(LivingExtension<?, ?> performer, @Nullable LivingExtension<?, ?> target, ItemStack heldStack) {
        if (((DelegatedEntityActionType)this.type).getCustomAction() != null && performer.getEntity().func_70681_au().nextFloat() < ((Float)((DelegatedEntityActionType)this.type).getCustomAction().getRight()).floatValue()) {
            ((Consumer)((DelegatedEntityActionType)this.type).getCustomAction().getLeft()).accept(this.selectedTarget);
        }
        this.selectedTarget.getEntity().curePotionEffects(heldStack);
        for (Pair<Supplier<EffectInstance>, Float> pair : ((DelegatedEntityActionType)this.type).getEffects()) {
            if (pair.getLeft() == null || !(performer.getEntity().func_70681_au().nextFloat() < ((Float)pair.getRight()).floatValue())) continue;
            EffectInstance effectInstance = (EffectInstance)((Supplier)pair.getLeft()).get();
            if (effectInstance.func_188419_a().func_76403_b()) {
                effectInstance.func_188419_a().func_180793_a(this.selectedTarget.getEntity(), this.selectedTarget.getEntity(), this.selectedTarget.getEntity(), effectInstance.func_76458_c(), 1.0);
                continue;
            }
            this.selectedTarget.getEntity().func_195064_c(new EffectInstance(effectInstance));
        }
        return true;
    }
}

