/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.core.world.action.delegated;

import com.craftingdead.core.world.action.Action;
import com.craftingdead.core.world.action.TargetSelector;
import com.craftingdead.core.world.action.delegated.AbstractDelegatedActionType;
import com.craftingdead.core.world.action.delegated.DelegatedAction;
import com.craftingdead.core.world.action.delegated.DelegatedEntityAction;
import com.craftingdead.core.world.entity.extension.LivingExtension;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.potion.EffectInstance;
import org.apache.commons.lang3.tuple.Pair;

public final class DelegatedEntityActionType
extends AbstractDelegatedActionType {
    private final TargetSelector targetSelector;
    private final List<Pair<Supplier<EffectInstance>, Float>> effects;
    @Nullable
    private final Pair<Consumer<LivingExtension<?, ?>>, Float> customAction;
    private final BooleanSupplier condition;

    private DelegatedEntityActionType(Builder builder) {
        super(builder);
        this.targetSelector = builder.targetSelector;
        this.effects = builder.effects;
        this.customAction = builder.customAction;
        this.condition = builder.condition;
    }

    public TargetSelector getTargetSelector() {
        return this.targetSelector;
    }

    public List<Pair<Supplier<EffectInstance>, Float>> getEffects() {
        return this.effects;
    }

    public Pair<Consumer<LivingExtension<?, ?>>, Float> getCustomAction() {
        return this.customAction;
    }

    public BooleanSupplier getCondition() {
        return this.condition;
    }

    @Override
    public Optional<? extends DelegatedAction> create(Action action) {
        return this.targetSelector.select(action.getPerformer(), action.getTarget().orElse(null)).map(target -> new DelegatedEntityAction(this, (LivingExtension<?, ?>)target));
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder
    extends AbstractDelegatedActionType.Builder<Builder> {
        private TargetSelector targetSelector = TargetSelector.SELF_ONLY;
        private final List<Pair<Supplier<EffectInstance>, Float>> effects = new ArrayList<Pair<Supplier<EffectInstance>, Float>>();
        @Nullable
        private Pair<Consumer<LivingExtension<?, ?>>, Float> customAction;
        private BooleanSupplier condition = () -> true;

        private Builder() {
            super((SELF x$0) -> new DelegatedEntityActionType((Builder)x$0));
        }

        public Builder setTargetSelector(TargetSelector targetSelector) {
            this.targetSelector = targetSelector;
            return this;
        }

        public Builder addEffect(Supplier<EffectInstance> effect, Float chance) {
            this.effects.add((Pair<Supplier<EffectInstance>, Float>)Pair.of(effect, (Object)chance));
            return this;
        }

        public Builder setCustomAction(Consumer<LivingExtension<?, ?>> customAction, Float chance) {
            this.customAction = Pair.of(customAction, (Object)chance);
            return this;
        }

        public Builder setCondition(BooleanSupplier condition) {
            this.condition = condition;
            return this;
        }
    }
}

