/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.core.world.action.reload;

import com.craftingdead.core.world.action.ActionType;
import com.craftingdead.core.world.action.reload.AbstractReloadAction;
import com.craftingdead.core.world.entity.extension.LivingExtension;
import com.craftingdead.core.world.gun.ammoprovider.AmmoProvider;
import com.craftingdead.core.world.gun.ammoprovider.RefillableAmmoProvider;
import javax.annotation.Nullable;

public class RefillableReloadAction
extends AbstractReloadAction {
    private final RefillableAmmoProvider ammoProvider;
    private int oldAmmoCount;

    public RefillableReloadAction(ActionType type, LivingExtension<?, ?> performer, @Nullable LivingExtension<?, ?> target) {
        super(type, performer, target);
        AmmoProvider ammoProvider = this.gun.getAmmoProvider();
        if (!(ammoProvider instanceof RefillableAmmoProvider)) {
            throw new IllegalStateException("No RefillableAmmoProvider present");
        }
        this.ammoProvider = (RefillableAmmoProvider)ammoProvider;
    }

    @Override
    public boolean start() {
        return (this.ammoProvider.hasInfiniteAmmo() || this.ammoProvider.getReserveSize() > 0) && super.start();
    }

    @Override
    protected void loadNewMagazineStack(boolean displayOnly) {
        if (!displayOnly) {
            this.oldAmmoCount = this.ammoProvider.getExpectedMagazine().getSize();
            this.ammoProvider.refillMagazine();
        }
    }

    @Override
    protected void revert() {
        this.ammoProvider.moveAmmoToReserve(this.ammoProvider.getExpectedMagazine().getSize());
        this.ammoProvider.moveAmmoToMagazine(this.oldAmmoCount);
    }
}

