/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.core.world.entity.ai;

import com.craftingdead.core.world.effect.ModMobEffects;
import com.craftingdead.core.world.entity.grenade.GrenadeEntity;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.potion.Effect;

public class FollowAttractiveGrenadeGoal
extends Goal {
    private final MobEntity goalOwner;
    private final double moveSpeedMultiplier;
    private GrenadeEntity grenade;
    private int delayCounter;

    public FollowAttractiveGrenadeGoal(MobEntity goalOwner, double moveSpeedMultiplier) {
        this.goalOwner = goalOwner;
        this.moveSpeedMultiplier = moveSpeedMultiplier;
        this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean func_75250_a() {
        if (this.goalOwner.func_70644_a((Effect)ModMobEffects.FLASH_BLINDNESS.get())) {
            return false;
        }
        List list = this.goalOwner.field_70170_p.func_217357_a(GrenadeEntity.class, this.goalOwner.func_174813_aQ().func_72314_b(20.0, 5.0, 20.0));
        GrenadeEntity nearestGrenade = null;
        double lastSqDistance = Double.MAX_VALUE;
        for (GrenadeEntity grenade : list) {
            double sqDistance;
            if (!grenade.isAttracting() || !((sqDistance = this.goalOwner.func_70068_e((Entity)grenade)) <= lastSqDistance)) continue;
            lastSqDistance = sqDistance;
            nearestGrenade = grenade;
        }
        if (nearestGrenade == null || !nearestGrenade.func_70089_S()) {
            return false;
        }
        this.grenade = nearestGrenade;
        return true;
    }

    public boolean func_75253_b() {
        if (!this.grenade.func_70089_S()) {
            return false;
        }
        if (this.goalOwner.func_70644_a((Effect)ModMobEffects.FLASH_BLINDNESS.get())) {
            return false;
        }
        if (this.grenade.field_70170_p != this.goalOwner.field_70170_p) {
            return false;
        }
        return this.goalOwner.func_70068_e((Entity)this.grenade) <= 256.0;
    }

    public void func_75249_e() {
        this.delayCounter = 0;
    }

    public void func_75251_c() {
        this.grenade = null;
    }

    public void func_75246_d() {
        this.goalOwner.func_70671_ap().func_220679_a(this.grenade.func_226277_ct_(), this.grenade.func_226280_cw_(), this.grenade.func_226281_cx_());
        if (--this.delayCounter <= 0) {
            this.delayCounter = 5 + this.goalOwner.func_70681_au().nextInt(10);
            this.goalOwner.func_70661_as().func_75497_a((Entity)this.grenade, this.moveSpeedMultiplier);
        }
    }
}

