/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.core.world.entity.ai;

import com.craftingdead.core.world.effect.ModMobEffects;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.potion.Effect;

public class LookAtEntityGoal<T extends Entity>
extends Goal {
    private final MobEntity goalOwner;
    private final float maxDistance;
    private final float chance;
    private final Class<T> watchedClass;
    private int lookDuration;
    private Entity watchedEntity;

    public LookAtEntityGoal(MobEntity goalowner, Class<T> watchedClass, float maxDistance) {
        this(goalowner, watchedClass, maxDistance, 0.02f);
    }

    public LookAtEntityGoal(MobEntity goalOwner, Class<T> watchedClass, float maxDistance, float chance) {
        this.goalOwner = goalOwner;
        this.watchedClass = watchedClass;
        this.maxDistance = maxDistance;
        this.chance = chance;
        this.func_220684_a(EnumSet.of(Goal.Flag.LOOK));
    }

    public boolean func_75250_a() {
        if (this.goalOwner.func_70644_a((Effect)ModMobEffects.FLASH_BLINDNESS.get())) {
            return false;
        }
        if (this.goalOwner.func_70681_au().nextFloat() >= this.chance) {
            return false;
        }
        List possibleEntities = this.goalOwner.field_70170_p.func_217357_a(this.watchedClass, this.goalOwner.func_174813_aQ().func_72314_b((double)this.maxDistance, 4.0, (double)this.maxDistance));
        double lastSqDistance = Double.MAX_VALUE;
        for (Entity grenade : possibleEntities) {
            double sqDistance = this.goalOwner.func_70068_e(grenade);
            if (!(sqDistance <= lastSqDistance)) continue;
            lastSqDistance = sqDistance;
            this.watchedEntity = grenade;
        }
        return this.watchedEntity != null;
    }

    public boolean func_75253_b() {
        if (!this.watchedEntity.func_70089_S()) {
            return false;
        }
        if (this.goalOwner.func_70644_a((Effect)ModMobEffects.FLASH_BLINDNESS.get())) {
            return false;
        }
        if (this.goalOwner.func_70068_e(this.watchedEntity) > (double)(this.maxDistance * this.maxDistance)) {
            return false;
        }
        return this.lookDuration > 0;
    }

    public void func_75249_e() {
        this.lookDuration = 40 + this.goalOwner.func_70681_au().nextInt(40);
    }

    public void func_75251_c() {
        this.watchedEntity = null;
    }

    public void func_75246_d() {
        this.goalOwner.func_70671_ap().func_220679_a(this.watchedEntity.func_226277_ct_(), this.watchedEntity.func_226280_cw_(), this.watchedEntity.func_226281_cx_());
        --this.lookDuration;
    }
}

