/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.core.world.entity.extension;

import com.craftingdead.core.capability.Capabilities;
import com.craftingdead.core.world.action.Action;
import com.craftingdead.core.world.entity.extension.EntitySnapshot;
import com.craftingdead.core.world.entity.extension.LivingExtensionImpl;
import com.craftingdead.core.world.entity.extension.LivingHandler;
import com.craftingdead.core.world.gun.Gun;
import java.util.Optional;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandlerModifiable;

public interface LivingExtension<E extends LivingEntity, H extends LivingHandler>
extends LivingHandler {
    public static final ResourceLocation CAPABILITY_KEY = new ResourceLocation("craftingdead", "living");

    public static <E extends LivingEntity> LivingExtension<E, ?> create(E entity) {
        return new LivingExtensionImpl(entity);
    }

    @Nonnull
    public static <E extends LivingEntity> LivingExtension<E, ?> getOrThrow(E living) {
        return Capabilities.getOrThrow(Capabilities.LIVING_EXTENSION, living, LivingExtension.class);
    }

    public void load();

    public Optional<H> getHandler(ResourceLocation var1);

    @Nonnull
    public H getHandlerOrThrow(ResourceLocation var1) throws IllegalStateException;

    public void registerHandler(ResourceLocation var1, H var2);

    default public boolean performAction(Action action, boolean sendUpdate) {
        return this.performAction(action, false, sendUpdate);
    }

    public boolean performAction(Action var1, boolean var2, boolean var3);

    public void cancelAction(boolean var1);

    public void setActionProgress(ProgressMonitor var1);

    public Optional<ProgressMonitor> getProgressMonitor();

    default public boolean isMonitoringAction() {
        return this.getProgressMonitor().isPresent();
    }

    public void setMovementBlocked(boolean var1);

    public boolean isMoving();

    public IItemHandlerModifiable getItemHandler();

    public EntitySnapshot getSnapshot(int var1) throws IndexOutOfBoundsException;

    public boolean isCrouching();

    public void setCrouching(boolean var1, boolean var2);

    default public float getModifiedAccuracy(float accuracy, Random random) {
        if (this.isMoving()) {
            accuracy -= 0.15f;
        } else if (this.isCrouching()) {
            accuracy += 0.15f;
        }
        if (!(this.getEntity() instanceof PlayerEntity)) {
            accuracy -= random.nextFloat();
        }
        return accuracy;
    }

    public E getEntity();

    default public World getLevel() {
        return ((LivingEntity)this.getEntity()).field_70170_p;
    }

    default public ItemStack getMainHandItem() {
        return this.getEntity().func_184614_ca();
    }

    default public LazyOptional<Gun> getMainHandGun() {
        return this.getMainHandItem().getCapability(Capabilities.GUN);
    }

    public static interface ProgressMonitor {
        public ITextComponent getMessage();

        public Optional<ITextComponent> getSubMessage();

        public float getProgress(float var1);

        public void stop();
    }
}

