/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.core.world.entity.extension;

import com.craftingdead.core.network.Synched;
import com.craftingdead.core.world.entity.extension.Visibility;
import java.util.Collection;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.DamageSource;
import net.minecraftforge.common.util.INBTSerializable;

public interface LivingHandler
extends INBTSerializable<CompoundNBT>,
Synched {
    default public void tick() {
    }

    default public float handleDamaged(DamageSource source, float amount) {
        return amount;
    }

    default public boolean handleHurt(DamageSource source, float amount) {
        return false;
    }

    default public boolean handleKill(Entity target) {
        return false;
    }

    default public boolean handleDeath(DamageSource cause) {
        return false;
    }

    default public boolean handleDeathLoot(DamageSource cause, Collection<ItemEntity> loot) {
        return false;
    }

    default public void handleStartTracking(ServerPlayerEntity playerEntity) {
    }

    default public boolean isMovementBlocked() {
        return false;
    }

    default public Visibility getVisibility() {
        return Visibility.VISIBLE;
    }

    default public CompoundNBT serializeNBT() {
        return new CompoundNBT();
    }

    default public void deserializeNBT(CompoundNBT nbt) {
    }
}

