/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.core.world.gun;

import com.craftingdead.core.capability.Capabilities;
import com.craftingdead.core.event.GunEvent;
import com.craftingdead.core.network.NetworkChannel;
import com.craftingdead.core.network.SynchedData;
import com.craftingdead.core.network.message.play.HitMessage;
import com.craftingdead.core.network.message.play.SecondaryActionMessage;
import com.craftingdead.core.network.message.play.SetFireModeMessage;
import com.craftingdead.core.network.message.play.TriggerPressedMessage;
import com.craftingdead.core.sounds.ModSoundEvents;
import com.craftingdead.core.util.RayTraceUtil;
import com.craftingdead.core.world.damagesource.ModDamageSource;
import com.craftingdead.core.world.entity.extension.EntitySnapshot;
import com.craftingdead.core.world.entity.extension.LivingExtension;
import com.craftingdead.core.world.entity.extension.PlayerExtension;
import com.craftingdead.core.world.gun.AbstractGunClient;
import com.craftingdead.core.world.gun.FireMode;
import com.craftingdead.core.world.gun.Gun;
import com.craftingdead.core.world.gun.PendingHit;
import com.craftingdead.core.world.gun.ammoprovider.AmmoProvider;
import com.craftingdead.core.world.gun.ammoprovider.AmmoProviderType;
import com.craftingdead.core.world.gun.attachment.Attachment;
import com.craftingdead.core.world.gun.attachment.Attachments;
import com.craftingdead.core.world.gun.magazine.Magazine;
import com.craftingdead.core.world.gun.skin.Paint;
import com.craftingdead.core.world.gun.skin.Skin;
import com.craftingdead.core.world.gun.skin.Skins;
import com.craftingdead.core.world.hat.Hat;
import com.craftingdead.core.world.inventory.ModEquipmentSlotType;
import com.craftingdead.core.world.item.enchantment.ModEnchantments;
import com.google.common.collect.Iterables;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.mojang.serialization.DynamicOps;
import io.netty.handler.codec.DecoderException;
import io.netty.handler.codec.EncoderException;
import java.io.IOException;
import java.util.AbstractList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractFireBlock;
import net.minecraft.block.BellBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.CampfireBlock;
import net.minecraft.block.TNTBlock;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.enchantment.UnbreakingEnchantment;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.merchant.villager.VillagerEntity;
import net.minecraft.entity.merchant.villager.WanderingTraderEntity;
import net.minecraft.entity.monster.CreeperEntity;
import net.minecraft.entity.monster.EndermanEntity;
import net.minecraft.entity.monster.SkeletonEntity;
import net.minecraft.entity.monster.VindicatorEntity;
import net.minecraft.entity.monster.WitchEntity;
import net.minecraft.entity.monster.ZombieEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.NBTDynamicOps;
import net.minecraft.nbt.StringNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.CombatRules;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.Util;
import net.minecraft.util.concurrent.ThreadTaskExecutor;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.LogicalSidedProvider;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.fml.network.PacketDistributor;
import net.minecraftforge.registries.ForgeRegistryEntry;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class AbstractGun
implements Gun,
INBTSerializable<CompoundNBT> {
    private static final Logger logger = LogManager.getLogger();
    private static final int BASE_SNAPSHOT_TICK_OFFSET = 3;
    public static final float HEADSHOT_MULTIPLIER = 4.0f;
    public static final byte HIT_VALIDATION_DELAY_TICKS = 3;
    private static final ScheduledExecutorService executorService = Executors.newScheduledThreadPool(3, new ThreadFactoryBuilder().setNameFormat("gun-pool-%s").setDaemon(true).setPriority(10).build());
    private static final DataParameter<ItemStack> PAINT_STACK = new DataParameter(1, DataSerializers.field_187196_f);
    private final SynchedData dataManager = new SynchedData();
    protected final ItemStack itemStack;
    private boolean wasTriggerPressed;
    private volatile int triggerPressedTicks;
    private volatile FireMode fireMode;
    private final AtomicInteger shotCount = new AtomicInteger();
    private Set<Attachment> attachments;
    private boolean attachmentsDirty;
    private final Iterator<FireMode> fireModeInfiniteIterator;
    private volatile boolean performingSecondaryAction;
    private final Lazy<AbstractGunClient<?>> client;
    private volatile long lastTickMs;
    private volatile AmmoProvider ammoProvider;
    private boolean ammoProviderChanged;
    @Nullable
    private volatile Future<?> gunFuture;
    protected volatile long lastShotMs;
    private boolean initialized;
    @Nullable
    private Skin skin;
    private boolean skinDirty;

    public <SELF extends AbstractGun> AbstractGun(Function<SELF, ? extends AbstractGunClient<? super SELF>> clientFactory, ItemStack itemStack, Set<FireMode> fireModes) {
        this.itemStack = itemStack;
        this.fireModeInfiniteIterator = Iterables.cycle(fireModes).iterator();
        this.fireMode = this.fireModeInfiniteIterator.next();
        this.client = FMLEnvironment.dist.isClient() ? Lazy.concurrentOf(() -> (AbstractGunClient)clientFactory.apply(this)) : Lazy.of(() -> {
            throw new IllegalStateException("Cannot access gun client on dedicated server");
        });
    }

    protected void initialize() {
        if (this.initialized) {
            throw new IllegalStateException("Already initialized");
        }
        this.initialized = true;
        GunEvent.Initialize event = new GunEvent.Initialize(this, this.itemStack, this.createAmmoProvider());
        MinecraftForge.EVENT_BUS.post((Event)event);
        this.setAmmoProvider(event.getAmmoProvider());
        this.attachments = new HashSet<Attachment>(event.getAttachments());
        this.dataManager.register(PAINT_STACK, ItemStack.field_190927_a);
    }

    protected abstract Set<FireMode> getFireModes();

    protected abstract AmmoProvider createAmmoProvider();

    @Override
    public void tick(LivingExtension<?, ?> living) {
        this.lastTickMs = Util.func_211177_b();
        if (!living.getLevel().func_201670_d() && !this.isTriggerPressed() && this.wasTriggerPressed) {
            this.triggerPressedTicks = living.getEntity().func_184102_h().func_71259_af();
        }
        this.wasTriggerPressed = this.isTriggerPressed();
        if (this.isPerformingSecondaryAction() && living.getEntity().func_70051_ag()) {
            this.setPerformingSecondaryAction(living, false, true);
        }
        if (living.getLevel().func_201670_d()) {
            ((AbstractGunClient)this.getClient()).handleTick(living);
        }
    }

    @Override
    public void reset(LivingExtension<?, ?> living) {
        this.setTriggerPressed(living, false, false);
        if (this.isPerformingSecondaryAction()) {
            this.setPerformingSecondaryAction(living, false, false);
        }
    }

    @Override
    public void setTriggerPressed(LivingExtension<?, ?> living, boolean triggerPressed, boolean sendUpdate) {
        if (triggerPressed == this.isTriggerPressed() || triggerPressed && (!this.canShoot(living) || MinecraftForge.EVENT_BUS.post((Event)new GunEvent.TriggerPressed(this, this.itemStack, living)))) {
            return;
        }
        if (triggerPressed) {
            this.gunFuture = executorService.scheduleAtFixedRate(() -> this.shoot(living), 0L, this.getFireDelayMs(), TimeUnit.MILLISECONDS);
        } else {
            this.stopShooting();
        }
        if (sendUpdate) {
            PacketDistributor.PacketTarget target = living.getLevel().func_201670_d() ? PacketDistributor.SERVER.noArg() : PacketDistributor.TRACKING_ENTITY.with(living::getEntity);
            NetworkChannel.PLAY.getSimpleChannel().send(target, (Object)new TriggerPressedMessage(living.getEntity().func_145782_y(), triggerPressed));
        }
    }

    @Override
    public boolean isTriggerPressed() {
        return this.gunFuture != null && !this.gunFuture.isDone();
    }

    private void stopShooting() {
        this.shotCount.set(0);
        if (this.gunFuture != null) {
            this.gunFuture.cancel(false);
        }
    }

    @Override
    public void validatePendingHit(PlayerExtension<ServerPlayerEntity> player, LivingExtension<?, ?> hitLiving, PendingHit pendingHit) {
        EntitySnapshot hitSnapshot;
        EntitySnapshot playerSnapshot;
        byte tickOffset = pendingHit.getTickOffset();
        if (tickOffset > 3) {
            logger.warn("Bad living hit packet received, tick offset is too big!");
            return;
        }
        int latencyTicks = ((ServerPlayerEntity)player.getEntity()).field_71138_i / 1000 * 20 + tickOffset;
        int tick = ((ServerPlayerEntity)player.getEntity()).func_184102_h().func_71259_af();
        if (tick - latencyTicks > this.triggerPressedTicks && !this.isTriggerPressed()) {
            return;
        }
        try {
            playerSnapshot = player.getSnapshot(tick - latencyTicks).combineUntrustedSnapshot(pendingHit.getPlayerSnapshot());
        }
        catch (IndexOutOfBoundsException e) {
            return;
        }
        try {
            hitSnapshot = hitLiving.getSnapshot(tick - latencyTicks - 3).combineUntrustedSnapshot(pendingHit.getHitSnapshot());
        }
        catch (IndexOutOfBoundsException e) {
            return;
        }
        if (!hitLiving.getEntity().func_233643_dh_()) {
            Random random = new Random(pendingHit.getRandomSeed());
            hitSnapshot.rayTrace(player.getLevel(), playerSnapshot, this.getRange(), this.getAccuracy(player, random), this.getShotCount(), random).ifPresent(hitPos -> this.hitEntity((LivingExtension<?, ?>)player, (Entity)hitLiving.getEntity(), (Vector3d)hitPos, false));
        }
    }

    protected abstract double getRange();

    protected abstract long getFireDelayMs();

    private void shoot(LivingExtension<?, ?> living) {
        int maxShots;
        Random random = new Random();
        long time = Util.func_211177_b();
        if (!this.isTriggerPressed() || time - this.lastTickMs >= 500L || !this.canShoot(living)) {
            this.stopShooting();
            return;
        }
        if (time - this.lastShotMs + 10L < this.getFireDelayMs()) {
            return;
        }
        this.lastShotMs = time;
        LogicalSide side = living.getLevel().func_201670_d() ? LogicalSide.CLIENT : LogicalSide.SERVER;
        ThreadTaskExecutor executor = (ThreadTaskExecutor)LogicalSidedProvider.WORKQUEUE.get(side);
        if (this.ammoProvider.getMagazine().map(Magazine::getSize).orElse(0) <= 0) {
            if (side.isServer()) {
                executor.execute(() -> {
                    living.getEntity().func_184185_a((SoundEvent)ModSoundEvents.DRY_FIRE.get(), 1.0f, 1.0f);
                    this.ammoProvider.reload(living);
                });
            }
            this.stopShooting();
            return;
        }
        int shotCount = this.shotCount.getAndIncrement();
        if (shotCount >= (maxShots = this.fireMode.getMaxShots().orElse(Integer.MAX_VALUE).intValue())) {
            this.stopShooting();
            return;
        }
        executor.execute(() -> this.processShot(living, random));
        if (side.isClient()) {
            ((AbstractGunClient)this.getClient()).handleShoot(living);
        }
        Thread.yield();
    }

    protected boolean canShoot(LivingExtension<?, ?> living) {
        return !living.getProgressMonitor().isPresent() && !living.getEntity().func_70051_ag() && !living.getEntity().func_175149_v();
    }

    protected abstract int getRoundsPerShot();

    protected void processShot(LivingExtension<?, ?> living, Random random) {
        int unbreakingLevel;
        Object entity = living.getEntity();
        World level = living.getLevel();
        MinecraftForge.EVENT_BUS.post((Event)new GunEvent.Shoot(this, this.itemStack, living));
        if (!(level.func_201670_d() || living.getEntity() instanceof PlayerEntity && ((PlayerEntity)living.getEntity()).func_184812_l_() || UnbreakingEnchantment.func_92097_a((ItemStack)this.itemStack, (int)(unbreakingLevel = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185307_s, (ItemStack)this.itemStack)), (Random)level.func_201674_k()))) {
            this.ammoProvider.getExpectedMagazine().decrementSize();
        }
        boolean hitEntity = false;
        HashSet<BlockState> blocksHit = new HashSet<BlockState>();
        block4: for (int i = 0; i < this.getRoundsPerShot(); ++i) {
            long randomSeed = level.func_82737_E() + (long)i;
            random.setSeed(randomSeed);
            RayTraceResult rayTraceResult = RayTraceUtil.rayTrace(entity, this.getRange(), this.getAccuracy(living, random), this.getShotCount(), random).orElse(null);
            if (rayTraceResult == null) continue;
            switch (rayTraceResult.func_216346_c()) {
                case BLOCK: {
                    BlockRayTraceResult blockRayTraceResult = (BlockRayTraceResult)rayTraceResult;
                    BlockState blockState = level.func_180495_p(blockRayTraceResult.func_216350_a());
                    this.hitBlock(living, (BlockRayTraceResult)rayTraceResult, blockState, level.func_201670_d() && (i == 0 || !blocksHit.contains(blockState)));
                    blocksHit.add(blockState);
                    continue block4;
                }
                case ENTITY: {
                    EntityRayTraceResult entityRayTraceResult = (EntityRayTraceResult)rayTraceResult;
                    if (!entityRayTraceResult.func_216348_a().func_70089_S() || entityRayTraceResult.func_216348_a() instanceof ServerPlayerEntity && entity instanceof ServerPlayerEntity) continue block4;
                    if (level.func_201670_d()) {
                        ((AbstractGunClient)this.getClient()).handleHitEntityPre(living, entityRayTraceResult.func_216348_a(), entityRayTraceResult.func_216347_e(), randomSeed);
                    }
                    this.hitEntity(living, entityRayTraceResult.func_216348_a(), entityRayTraceResult.func_216347_e(), !hitEntity && level.func_201670_d());
                    hitEntity = true;
                    continue block4;
                }
            }
        }
    }

    protected abstract float getDamage();

    private void hitEntity(LivingExtension<?, ?> living, Entity hitEntity, Vector3d hitPos, boolean playSound) {
        GunEvent.HitEntity event;
        Object entity = living.getEntity();
        float damage = this.getDamage();
        float armorPenetration = Math.min((1.0f + (float)EnchantmentHelper.func_77506_a((Enchantment)((Enchantment)ModEnchantments.ARMOR_PENETRATION.get()), (ItemStack)this.itemStack) / 255.0f) * this.ammoProvider.getExpectedMagazine().getArmorPenetration(), 1.0f);
        if (armorPenetration > 0.0f && hitEntity instanceof LivingEntity) {
            LivingEntity livingEntityHit = (LivingEntity)hitEntity;
            float reducedDamage = damage - CombatRules.func_189427_a((float)damage, (float)livingEntityHit.func_70658_aO(), (float)((float)livingEntityHit.func_110148_a(Attributes.field_233827_j_).func_111126_e()));
            damage += reducedDamage * armorPenetration;
        }
        boolean headshot = false;
        if (hitEntity instanceof LivingEntity) {
            LivingExtension<LivingEntity, ?> hitLiving = LivingExtension.getOrThrow((LivingEntity)hitEntity);
            double chinHeight = hitEntity.func_226278_cu_() + (double)hitEntity.func_70047_e() - (double)0.2f;
            boolean bl = headshot = (hitEntity instanceof PlayerEntity || hitEntity instanceof ZombieEntity || hitEntity instanceof SkeletonEntity || hitEntity instanceof CreeperEntity || hitEntity instanceof EndermanEntity || hitEntity instanceof WitchEntity || hitEntity instanceof VillagerEntity || hitEntity instanceof VindicatorEntity || hitEntity instanceof WanderingTraderEntity) && hitPos.field_72448_b >= chinHeight;
            if (headshot) {
                damage *= 4.0f * (1.0f - hitLiving.getItemHandler().getStackInSlot(ModEquipmentSlotType.HAT.getIndex()).getCapability(Capabilities.HAT).map(Hat::getHeadshotReductionPercentage).orElse(Float.valueOf(0.0f)).floatValue());
            }
        }
        if (MinecraftForge.EVENT_BUS.post((Event)(event = new GunEvent.HitEntity(this, this.itemStack, living, hitEntity, damage, hitPos, headshot)))) {
            return;
        }
        damage = event.getDamage();
        headshot = event.isHeadshot();
        if (living.getLevel().func_201670_d()) {
            ((AbstractGunClient)this.getClient()).handleHitEntityPost(living, hitEntity, hitPos, playSound, headshot);
        } else {
            hitEntity.field_70172_ad = 0;
            ModDamageSource.causeDamageWithoutKnockback(hitEntity, ModDamageSource.causeGunDamage(entity, this.itemStack, headshot), damage);
            AbstractGun.checkCreateExplosion(this.itemStack, entity, hitPos);
            if (EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185311_w, (ItemStack)this.itemStack) > 0) {
                hitEntity.func_70015_d(100);
            }
            if (hitEntity instanceof LivingEntity) {
                LivingEntity hitLivingEntity = (LivingEntity)hitEntity;
                if (entity instanceof ServerPlayerEntity) {
                    boolean dead = hitLivingEntity.func_233643_dh_();
                    NetworkChannel.PLAY.getSimpleChannel().send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)entity), (Object)new HitMessage(hitPos, dead));
                }
            }
        }
    }

    private void hitBlock(LivingExtension<?, ?> living, BlockRayTraceResult result, BlockState blockState, boolean playSound) {
        Object entity = living.getEntity();
        Block block = blockState.func_177230_c();
        World level = ((LivingEntity)entity).field_70170_p;
        BlockPos blockPos = result.func_216350_a();
        GunEvent.HitBlock event = new GunEvent.HitBlock(this, this.itemStack, result, blockState, living, level);
        if (MinecraftForge.EVENT_BUS.post((Event)event)) {
            return;
        }
        if (level.func_201670_d()) {
            ((AbstractGunClient)this.getClient()).handleHitBlock(living, result, blockState, playSound);
        } else {
            if (block instanceof BellBlock) {
                ((BellBlock)block).func_226884_a_(level, blockState, result, entity instanceof PlayerEntity ? (PlayerEntity)entity : null, playSound);
            }
            if (block instanceof TNTBlock) {
                block.catchFire(blockState, ((LivingEntity)entity).field_70170_p, blockPos, null, entity instanceof LivingEntity ? entity : null);
                ((LivingEntity)entity).field_70170_p.func_217377_a(blockPos, false);
            }
            AbstractGun.checkCreateExplosion(this.itemStack, entity, result.func_216347_e());
            if (EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185311_w, (ItemStack)this.itemStack) > 0) {
                if (CampfireBlock.func_241470_h_((BlockState)blockState)) {
                    level.func_180501_a(blockPos, (BlockState)blockState.func_206870_a((Property)BlockStateProperties.field_208190_q, (Comparable)Boolean.valueOf(true)), 11);
                } else {
                    BlockPos faceBlockPos = blockPos.func_177972_a(result.func_216354_b());
                    if (AbstractFireBlock.func_241465_a_((World)level, (BlockPos)faceBlockPos, (Direction)entity.func_174811_aO())) {
                        BlockState blockstate1 = AbstractFireBlock.func_235326_a_((IBlockReader)level, (BlockPos)faceBlockPos);
                        level.func_180501_a(faceBlockPos, blockstate1, 11);
                    }
                }
            }
        }
    }

    @Override
    public Set<Attachment> getAttachments() {
        return Collections.unmodifiableSet(this.attachments);
    }

    @Override
    public void setAttachments(Set<Attachment> attachments) {
        this.attachments = attachments;
    }

    @Override
    public ItemStack getPaintStack() {
        return this.dataManager.get(PAINT_STACK);
    }

    @Override
    public void setPaintStack(ItemStack paintStack) {
        this.dataManager.set(PAINT_STACK, paintStack);
        this.setSkin(paintStack.getCapability(Capabilities.PAINT).map(Paint::getSkin).map(arg_0 -> Skins.REGISTRY.func_230516_a_(arg_0)).orElse(null));
    }

    @Override
    public Skin getSkin() {
        return this.skin;
    }

    @Override
    public void setSkin(Skin skin) {
        this.skin = skin;
        this.skinDirty = true;
    }

    @Override
    public void toggleFireMode(LivingExtension<?, ?> living, boolean sendUpdate) {
        if (this.fireModeInfiniteIterator.hasNext()) {
            this.setFireMode(living, this.fireModeInfiniteIterator.next(), sendUpdate);
        }
    }

    @Override
    public void setFireMode(LivingExtension<?, ?> living, FireMode fireMode, boolean sendUpdate) {
        this.fireMode = fireMode;
        living.getEntity().func_184185_a((SoundEvent)ModSoundEvents.TOGGLE_FIRE_MODE.get(), 1.0f, 1.0f);
        if (living.getEntity() instanceof PlayerEntity) {
            ((PlayerEntity)living.getEntity()).func_146105_b((ITextComponent)new TranslationTextComponent("message.switch_fire_mode", new Object[]{new TranslationTextComponent(this.fireMode.getTranslationKey())}), true);
        }
        if (sendUpdate) {
            PacketDistributor.PacketTarget target = living.getLevel().func_201670_d() ? PacketDistributor.SERVER.noArg() : PacketDistributor.TRACKING_ENTITY.with(living::getEntity);
            NetworkChannel.PLAY.getSimpleChannel().send(target, (Object)new SetFireModeMessage(living.getEntity().func_145782_y(), this.fireMode));
        }
    }

    @Override
    public boolean isPerformingSecondaryAction() {
        return this.performingSecondaryAction;
    }

    @Override
    public void setPerformingSecondaryAction(LivingExtension<?, ?> living, boolean performingAction, boolean sendUpdate) {
        if (performingAction == this.performingSecondaryAction || performingAction && living.getEntity().func_70051_ag()) {
            return;
        }
        this.performingSecondaryAction = performingAction;
        if (living.getLevel().func_201670_d()) {
            ((AbstractGunClient)this.getClient()).handleToggleSecondaryAction(living);
        }
        if (sendUpdate) {
            PacketDistributor.PacketTarget target = living.getLevel().func_201670_d() ? PacketDistributor.SERVER.noArg() : PacketDistributor.TRACKING_ENTITY.with(living::getEntity);
            NetworkChannel.PLAY.getSimpleChannel().send(target, (Object)new SecondaryActionMessage(living.getEntity().func_145782_y(), this.isPerformingSecondaryAction()));
        }
    }

    protected int getShotCount() {
        return this.shotCount.get();
    }

    @Override
    public FireMode getFireMode() {
        return this.fireMode;
    }

    @Override
    public AbstractGunClient<?> getClient() {
        return (AbstractGunClient)this.client.get();
    }

    @Override
    public AmmoProvider getAmmoProvider() {
        return this.ammoProvider;
    }

    @Override
    public void setAmmoProvider(AmmoProvider ammoProvider) {
        this.ammoProvider = ammoProvider;
        this.ammoProviderChanged = true;
    }

    @Override
    public ItemStack getItemStack() {
        return this.itemStack;
    }

    public CompoundNBT serializeNBT() {
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_74778_a("ammoProviderType", this.ammoProvider.getType().getRegistryName().toString());
        nbt.func_218657_a("ammoProvider", this.ammoProvider.serializeNBT());
        ListNBT attachmentsNbt = this.attachments.stream().map(ForgeRegistryEntry::getRegistryName).map(ResourceLocation::toString).map(StringNBT::func_229705_a_).collect(ListNBT::new, AbstractList::add, List::addAll);
        nbt.func_218657_a("attachments", (INBT)attachmentsNbt);
        nbt.func_218657_a("paintStack", (INBT)this.getPaintStack().serializeNBT());
        if (this.skin != null) {
            nbt.func_218657_a("skin", (INBT)Skin.CODEC.encodeStart((DynamicOps)NBTDynamicOps.field_210820_a, () -> this.skin).getOrThrow(false, arg_0 -> ((Logger)logger).error(arg_0)));
        }
        return nbt;
    }

    public void deserializeNBT(CompoundNBT nbt) {
        if (nbt.func_150297_b("ammoProviderType", 8)) {
            this.setAmmoProvider(((AmmoProviderType)GameRegistry.findRegistry(AmmoProviderType.class).getValue(new ResourceLocation(nbt.func_74779_i("ammoProviderType")))).create());
            this.ammoProvider.deserializeNBT((INBT)nbt.func_74775_l("ammoProvider"));
            this.ammoProviderChanged = true;
        }
        this.setAttachments(nbt.func_150295_c("attachments", 8).stream().map(INBT::func_150285_a_).map(ResourceLocation::new).map(arg_0 -> ((IForgeRegistry)((IForgeRegistry)Attachments.REGISTRY.get())).getValue(arg_0)).collect(Collectors.toSet()));
        this.setPaintStack(ItemStack.func_199557_a((CompoundNBT)nbt.func_74775_l("paintStack")));
        this.skin = Skin.CODEC.parse((DynamicOps)NBTDynamicOps.field_210820_a, (Object)nbt.func_74781_a("skin")).result().map(Supplier::get).orElse(null);
    }

    @Override
    public void encode(PacketBuffer out, boolean writeAll) {
        SynchedData.pack(writeAll ? this.dataManager.getAll() : this.dataManager.packDirty(), out);
        if (writeAll || this.attachmentsDirty) {
            out.func_150787_b(this.attachments.size());
            this.attachments.forEach(arg_0 -> ((PacketBuffer)out).writeRegistryId(arg_0));
        } else {
            out.func_150787_b(-1);
        }
        this.attachmentsDirty = false;
        if (this.ammoProviderChanged || writeAll) {
            this.ammoProviderChanged = false;
            out.writeBoolean(true);
            out.writeRegistryId((IForgeRegistryEntry)this.ammoProvider.getType());
        } else {
            out.writeBoolean(false);
        }
        this.ammoProvider.encode(out, this.ammoProviderChanged || writeAll);
        if (this.skinDirty || writeAll) {
            this.skinDirty = false;
            out.writeBoolean(true);
            if (this.skin == null) {
                out.writeBoolean(true);
            } else {
                out.writeBoolean(false);
                try {
                    out.func_240629_a_(Skin.CODEC, () -> this.skin);
                }
                catch (IOException e) {
                    throw new EncoderException((Throwable)e);
                }
            }
        } else {
            out.writeBoolean(false);
        }
    }

    @Override
    public void decode(PacketBuffer in) {
        this.dataManager.assignValues(SynchedData.unpack(in));
        int size = in.func_150792_a();
        if (size > -1) {
            this.attachments.clear();
            for (int i = 0; i < size; ++i) {
                this.attachments.add((Attachment)in.readRegistryIdSafe(Attachment.class));
            }
        }
        if (in.readBoolean()) {
            this.ammoProvider = ((AmmoProviderType)in.readRegistryIdSafe(AmmoProviderType.class)).create();
        }
        this.ammoProvider.decode(in);
        if (in.readBoolean()) {
            if (in.readBoolean()) {
                this.skin = null;
            } else {
                try {
                    this.skin = (Skin)((Supplier)in.func_240628_a_(Skin.CODEC)).get();
                }
                catch (IOException e) {
                    throw new DecoderException((Throwable)e);
                }
            }
        }
    }

    @Override
    public boolean requiresSync() {
        return this.attachmentsDirty || this.dataManager.isDirty() || this.ammoProvider.requiresSync() || this.skinDirty;
    }

    private static void checkCreateExplosion(ItemStack magazineStack, Entity entity, Vector3d position) {
        float explosionSize = (float)EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185309_u, (ItemStack)magazineStack) / (float)Enchantments.field_185309_u.func_77325_b();
        if (explosionSize > 0.0f) {
            entity.field_70170_p.func_217385_a(entity, position.func_82615_a(), position.func_82617_b(), position.func_82616_c(), explosionSize, Explosion.Mode.NONE);
        }
    }
}

