/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.core.world.gun.ammoprovider;

import com.craftingdead.core.network.Synched;
import com.craftingdead.core.world.action.ActionType;
import com.craftingdead.core.world.action.ActionTypes;
import com.craftingdead.core.world.entity.extension.LivingExtension;
import com.craftingdead.core.world.gun.ammoprovider.AmmoProvider;
import com.craftingdead.core.world.gun.ammoprovider.AmmoProviderType;
import com.craftingdead.core.world.gun.ammoprovider.AmmoProviderTypes;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.PacketBuffer;

public class MagazineAmmoProvider
implements AmmoProvider {
    private ItemStack magazineStack;
    private boolean stackChanged;

    public MagazineAmmoProvider() {
        this(ItemStack.field_190927_a);
    }

    public MagazineAmmoProvider(ItemStack magazineStack) {
        this.magazineStack = magazineStack;
    }

    public CompoundNBT serializeNBT() {
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_218657_a("magazineStack", (INBT)this.magazineStack.serializeNBT());
        return nbt;
    }

    public void deserializeNBT(CompoundNBT nbt) {
        if (nbt.func_150297_b("magazineStack", 10)) {
            this.magazineStack = ItemStack.func_199557_a((CompoundNBT)nbt.func_74775_l("magazineStack"));
            this.stackChanged = true;
        }
    }

    @Override
    public void encode(PacketBuffer out, boolean writeAll) {
        if (this.stackChanged || writeAll) {
            out.writeBoolean(true);
            out.func_150788_a(this.magazineStack);
            this.stackChanged = false;
        } else {
            out.writeBoolean(false);
        }
        this.getMagazine().ifPresent(magazine -> magazine.encode(out, writeAll));
    }

    @Override
    public void decode(PacketBuffer in) {
        if (in.readBoolean()) {
            this.magazineStack = in.func_150791_c();
        }
        this.getMagazine().ifPresent(magazine -> magazine.decode(in));
    }

    @Override
    public boolean requiresSync() {
        return this.getMagazine().map(Synched::requiresSync).orElse(false) != false || this.stackChanged;
    }

    @Override
    public void reload(LivingExtension<?, ?> living) {
        living.performAction(((ActionType)ActionTypes.MAGAZINE_RELOAD.get()).createAction(living, null), true);
    }

    @Override
    public void unload(LivingExtension<?, ?> living) {
        living.performAction(((ActionType)ActionTypes.REMOVE_MAGAZINE.get()).createAction(living, null), true);
    }

    @Override
    public int getReserveSize() {
        return 0;
    }

    @Override
    public ItemStack getMagazineStack() {
        return this.magazineStack;
    }

    public void setMagazineStack(ItemStack magazineStack) {
        this.magazineStack = magazineStack;
        this.stackChanged = true;
    }

    @Override
    public AmmoProviderType getType() {
        return (AmmoProviderType)AmmoProviderTypes.MAGAZINE.get();
    }
}

