/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.core.world.gun.type;

import com.craftingdead.core.world.entity.extension.LivingExtension;
import com.craftingdead.core.world.gun.AbstractGun;
import com.craftingdead.core.world.gun.FireMode;
import com.craftingdead.core.world.gun.Gun;
import com.craftingdead.core.world.gun.ammoprovider.AmmoProvider;
import com.craftingdead.core.world.gun.attachment.Attachment;
import com.craftingdead.core.world.gun.attachment.AttachmentLike;
import com.craftingdead.core.world.gun.type.AbstractGunType;
import com.craftingdead.core.world.gun.type.TypedGunClient;
import com.craftingdead.core.world.item.combatslot.CombatSlotType;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.SoundEvent;

public class TypedGun<T extends AbstractGunType>
extends AbstractGun {
    private final T type;

    public static <T extends AbstractGunType> TypedGun<T> create(Function<TypedGun<T>, ? extends TypedGunClient<? super TypedGun<T>>> clientFactory, ItemStack itemStack, T type) {
        TypedGun<T> gun = new TypedGun<T>(clientFactory, itemStack, type);
        gun.initialize();
        return gun;
    }

    protected <SELF extends TypedGun<T>> TypedGun(Function<SELF, ? extends TypedGunClient<? super SELF>> clientFactory, ItemStack itemStack, T type) {
        super(clientFactory, itemStack, ((AbstractGunType)type).getFireModes());
        this.type = type;
    }

    public T getType() {
        return this.type;
    }

    @Override
    public boolean isAcceptedAttachment(ItemStack itemStack) {
        return itemStack.func_77973_b() instanceof AttachmentLike && ((AbstractGunType)this.type).getAcceptedAttachments().contains((Object)((AttachmentLike)itemStack.func_77973_b()).asAttachment());
    }

    @Override
    public Gun.SecondaryActionTrigger getSecondaryActionTrigger() {
        return ((AbstractGunType)this.type).getSecondaryActionTrigger();
    }

    @Override
    public Optional<SoundEvent> getReloadSound() {
        return ((AbstractGunType)this.type).getReloadSound();
    }

    @Override
    public int getReloadDurationTicks() {
        return ((AbstractGunType)this.type).getReloadDurationTicks();
    }

    @Override
    public Set<? extends Item> getAcceptedMagazines() {
        return ((AbstractGunType)this.type).getAcceptedMagazines();
    }

    @Override
    public ItemStack getDefaultMagazineStack() {
        return ((AbstractGunType)this.type).getDefaultMagazine().func_190903_i();
    }

    @Override
    public CombatSlotType getSlotType() {
        return ((AbstractGunType)this.type).getCombatSlotType();
    }

    @Override
    protected boolean canShoot(LivingExtension<?, ?> living) {
        return super.canShoot(living) && ((AbstractGunType)this.type).getTriggerPredicate().test(this);
    }

    @Override
    public float getAccuracy(LivingExtension<?, ?> living, Random random) {
        float accuracy = ((AbstractGunType)this.type).getAccuracyPct() * this.getAttachmentMultiplier(Attachment.MultiplierType.ACCURACY);
        return Math.min(living.getModifiedAccuracy(accuracy, random), 1.0f);
    }

    @Override
    protected Set<FireMode> getFireModes() {
        return ((AbstractGunType)this.type).getFireModes();
    }

    @Override
    protected AmmoProvider createAmmoProvider() {
        return ((AbstractGunType)this.type).createAmmoProvider();
    }

    @Override
    protected double getRange() {
        return ((AbstractGunType)this.type).getRange();
    }

    @Override
    protected long getFireDelayMs() {
        return ((AbstractGunType)this.type).getFireDelayMs();
    }

    @Override
    protected int getRoundsPerShot() {
        return ((AbstractGunType)this.type).getRoundsPerShot();
    }

    @Override
    protected float getDamage() {
        return ((AbstractGunType)this.type).getDamage();
    }
}

