/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.core.world.inventory;

import com.craftingdead.core.capability.Capabilities;
import com.craftingdead.core.world.gun.attachment.AttachmentLike;
import com.craftingdead.core.world.gun.skin.Paint;
import com.craftingdead.core.world.inventory.GunCraftSlot;
import com.craftingdead.core.world.inventory.GunCraftSlotType;
import com.craftingdead.core.world.inventory.ModEquipmentSlotType;
import com.craftingdead.core.world.inventory.ModMenuTypes;
import com.craftingdead.core.world.inventory.PredicateItemHandlerSlot;
import com.craftingdead.core.world.inventory.PredicateSlot;
import com.craftingdead.core.world.item.HatItem;
import com.craftingdead.core.world.item.MeleeWeaponItem;
import java.util.function.BiPredicate;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.CraftResultInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Inventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class EquipmentMenu
extends Container {
    private final IItemHandler equipment;
    private final CraftResultInventory outputInventory = new CraftResultInventory();
    private final Inventory craftingInventory = new Inventory(4);

    public EquipmentMenu(int id, PlayerInventory playerInventory) {
        this(id, playerInventory, (IItemHandler)new ItemStackHandler(ModEquipmentSlotType.values().length));
    }

    public EquipmentMenu(int id, PlayerInventory playerInventory, IItemHandler equipment) {
        super((ContainerType)ModMenuTypes.EQUIPMENT.get(), id);
        this.equipment = equipment;
        this.craftingInventory.func_110134_a(arg_0 -> ((EquipmentMenu)this).func_75130_a(arg_0));
        int slotSize = 18;
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 9; ++x) {
                this.func_75146_a(new Slot((IInventory)playerInventory, x + (y + 1) * 9, 8 + x * 18, 84 + y * 18));
            }
        }
        for (int x = 0; x < 9; ++x) {
            this.func_75146_a(new Slot((IInventory)playerInventory, x, 8 + x * 18, 142));
        }
        int equipmentColumnX = 62;
        int equipmentColumnY = 8;
        this.func_75146_a((Slot)new PredicateItemHandlerSlot(this.equipment, ModEquipmentSlotType.GUN.getIndex(), equipmentColumnX, equipmentColumnY, (slot, itemStack) -> itemStack.getCapability(Capabilities.GUN).isPresent()));
        this.func_75146_a((Slot)new PredicateItemHandlerSlot(this.equipment, ModEquipmentSlotType.MELEE.getIndex(), equipmentColumnX, equipmentColumnY += 18, (slot, itemStack) -> itemStack.func_77973_b() instanceof MeleeWeaponItem));
        this.func_75146_a((Slot)new PredicateItemHandlerSlot(this.equipment, ModEquipmentSlotType.HAT.getIndex(), equipmentColumnX, equipmentColumnY += 18, (slot, itemStack) -> itemStack.func_77973_b() instanceof HatItem));
        this.func_75146_a((Slot)new PredicateItemHandlerSlot(this.equipment, ModEquipmentSlotType.CLOTHING.getIndex(), equipmentColumnX, equipmentColumnY += 18, (slot, itemStack) -> itemStack.getCapability(Capabilities.CLOTHING).isPresent()));
        this.func_75146_a((Slot)new PredicateItemHandlerSlot(this.equipment, ModEquipmentSlotType.VEST.getIndex(), equipmentColumnX + 18, equipmentColumnY, (slot, itemStack) -> itemStack.getCapability(Capabilities.STORAGE).map(storage -> storage.isValidForSlot(ModEquipmentSlotType.VEST)).orElse(false)));
        int gunCraftSlotGap = 3;
        int gunCraftY = 8;
        this.func_75146_a(new GunCraftSlot(this.outputInventory, 0, 125, 29, this.craftingInventory));
        BiPredicate<PredicateSlot, ItemStack> attachmentOrPaintPredicate = (slot, itemStack) -> this.getGunStack().getCapability(Capabilities.GUN).map(gun -> gun.isAcceptedAttachment((ItemStack)itemStack)).orElse(false);
        BiPredicate<PredicateSlot, ItemStack> attachmentPredicate = (slot, itemStack) -> itemStack.func_77973_b() instanceof AttachmentLike && ((AttachmentLike)itemStack.func_77973_b()).asAttachment().getInventorySlot().getIndex() == slot.getSlotIndex();
        this.func_75146_a(new PredicateSlot((IInventory)this.craftingInventory, GunCraftSlotType.MUZZLE_ATTACHMENT.getIndex(), 104, 29, attachmentPredicate.and(attachmentOrPaintPredicate)));
        this.func_75146_a(new PredicateSlot((IInventory)this.craftingInventory, GunCraftSlotType.UNDERBARREL_ATTACHMENT.getIndex(), 125, 50, attachmentPredicate.and(attachmentOrPaintPredicate)));
        this.func_75146_a(new PredicateSlot((IInventory)this.craftingInventory, GunCraftSlotType.OVERBARREL_ATTACHMENT.getIndex(), 125, 8, attachmentPredicate.and(attachmentOrPaintPredicate)));
        this.func_75146_a(new PredicateSlot((IInventory)this.craftingInventory, GunCraftSlotType.PAINT.getIndex(), 146, 29, (slot, itemStack) -> Paint.isValid(this.getGunStack(), itemStack)));
    }

    public boolean func_75145_c(PlayerEntity playerEntity) {
        return true;
    }

    public void func_75134_a(PlayerEntity playerEntity) {
        super.func_75134_a(playerEntity);
        if (!playerEntity.field_70170_p.func_201670_d()) {
            this.func_193327_a(playerEntity, playerEntity.field_70170_p, (IInventory)this.craftingInventory);
            this.func_193327_a(playerEntity, playerEntity.field_70170_p, (IInventory)this.outputInventory);
        }
    }

    public IItemHandler getItemHandler() {
        return this.equipment;
    }

    public ItemStack getGunStack() {
        return this.outputInventory.func_70301_a(0);
    }

    public boolean isCraftingInventoryEmpty() {
        return this.craftingInventory.func_191420_l();
    }

    public boolean isCraftable() {
        return this.getGunStack().getCapability(Capabilities.GUN).map(gun -> {
            for (int i = 0; i < this.craftingInventory.func_70302_i_(); ++i) {
                ItemStack itemStack = this.craftingInventory.func_70301_a(i);
                if (itemStack.func_190926_b() || gun.isAcceptedAttachment(itemStack) || Paint.isValid(this.getGunStack(), itemStack)) continue;
                return false;
            }
            return true;
        }).orElse(false);
    }

    public ItemStack func_82846_b(PlayerEntity playerEntity, int clickedIndex) {
        Slot clickedSlot = (Slot)this.field_75151_b.get(clickedIndex);
        if (clickedSlot != null && clickedSlot.func_75216_d()) {
            if (clickedSlot instanceof GunCraftSlot) {
                return ItemStack.field_190927_a;
            }
            ItemStack clickedStack = clickedSlot.func_75211_c();
            if (clickedIndex < 36 ? !this.func_75135_a(clickedStack, 36, this.field_75151_b.size(), true) : !this.func_75135_a(clickedStack, 0, 36, false)) {
                return ItemStack.field_190927_a;
            }
            if (clickedStack.func_190926_b()) {
                clickedSlot.func_75215_d(ItemStack.field_190927_a);
            } else {
                clickedSlot.func_75218_e();
            }
        }
        return ItemStack.field_190927_a;
    }
}

