/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.core.world.item;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.registries.IRegistryDelegate;

public class ArbitraryTooltips {
    private static final Multimap<Supplier<Item>, TooltipFunction> toRegister = ArrayListMultimap.create();
    private static final Multimap<IRegistryDelegate<Item>, TooltipFunction> functions = ArrayListMultimap.create();

    public static void registerTooltip(Supplier<Item> item, TooltipFunction function) {
        toRegister.put(item, (Object)function);
    }

    public static void registerTooltip(Item item, TooltipFunction function) {
        functions.put((Object)item.delegate, (Object)function);
    }

    public static void registerAll(RegistryEvent.Register<Item> event) {
        toRegister.asMap().forEach((supplier, lines) -> functions.putAll((Object)((Item)supplier.get()).delegate, (Iterable)lines));
        toRegister.clear();
    }

    public static Collection<TooltipFunction> getFunctions(Item item) {
        return functions.get((Object)item.delegate);
    }

    @FunctionalInterface
    public static interface TooltipFunction {
        @Nullable
        public ITextComponent createTooltip(ItemStack var1, @Nullable World var2, ITooltipFlag var3);
    }
}

