/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.core.world.item.crafting;

import com.craftingdead.core.capability.Capabilities;
import com.craftingdead.core.world.gun.magazine.Magazine;
import com.craftingdead.core.world.item.crafting.ModRecipeSerializers;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapedRecipe;
import net.minecraft.item.crafting.SpecialRecipe;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class UpgradeMagazineRecipe
extends SpecialRecipe {
    private static final int MIDDLE_SLOT_INDEX = 4;
    private final Ingredient magazine;
    private final ItemStack nextTier;

    public UpgradeMagazineRecipe(ResourceLocation id, Ingredient magazine, ItemStack nextTier) {
        super(id);
        this.magazine = magazine;
        this.nextTier = nextTier;
    }

    public boolean matches(CraftingInventory inventory, World world) {
        block3: for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            switch (i) {
                case 4: {
                    if (this.magazine.test(inventory.func_70301_a(i))) continue block3;
                    return false;
                }
                default: {
                    if (Tags.Items.NUGGETS_IRON.func_230235_a_((Object)inventory.func_70301_a(i).func_77973_b())) continue block3;
                    return false;
                }
            }
        }
        return true;
    }

    public ItemStack assemble(CraftingInventory inventory) {
        Magazine magazine = Capabilities.getOrThrow(Capabilities.MAGAZINE, (ICapabilityProvider)inventory.func_70301_a(4), Magazine.class);
        Capabilities.getOrThrow(Capabilities.MAGAZINE, (ICapabilityProvider)this.nextTier, Magazine.class).setSize(magazine.getSize());
        return this.nextTier;
    }

    public boolean func_194133_a(int width, int height) {
        return width * height == 9;
    }

    public IRecipeSerializer<?> func_199559_b() {
        return (IRecipeSerializer)ModRecipeSerializers.UPGRADE_MAGAZINE.get();
    }

    public static class Serializer
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<UpgradeMagazineRecipe> {
        public UpgradeMagazineRecipe fromJson(ResourceLocation id, JsonObject json) {
            return new UpgradeMagazineRecipe(id, Ingredient.func_199802_a((JsonElement)json.get("magazine")), ShapedRecipe.func_199798_a((JsonObject)json.getAsJsonObject("nextTier")));
        }

        public UpgradeMagazineRecipe fromNetwork(ResourceLocation id, PacketBuffer buf) {
            return new UpgradeMagazineRecipe(id, Ingredient.func_199566_b((PacketBuffer)buf), buf.func_150791_c());
        }

        public void toNetwork(PacketBuffer buf, UpgradeMagazineRecipe recipe) {
            recipe.magazine.func_199564_a(buf);
            buf.func_150788_a(recipe.nextTier);
        }
    }
}

