/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.clumps;

import com.blamejared.clumps.ClumpsClient;
import com.blamejared.clumps.entities.EntityXPOrbBig;
import com.blamejared.clumps.events.EXPCloneEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.item.ExperienceOrbEntity;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

@Mod(value="clumps")
public class Clumps {
    public static final String MODID = "clumps";
    private static final DeferredRegister<EntityType<?>> DEFERRED_REGISTER = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ENTITIES, (String)"clumps");
    public static final RegistryObject<EntityType<EntityXPOrbBig>> BIG_ORB_ENTITY_TYPE = DEFERRED_REGISTER.register("xp_orb_big", () -> EntityType.Builder.func_220322_a(EntityXPOrbBig::new, (EntityClassification)EntityClassification.MISC).func_220321_a(0.5f, 0.5f).func_206830_a("clumps:xp_orb_big"));
    private static final List<ExperienceOrbEntity> orbs = new ArrayList<ExperienceOrbEntity>();

    public Clumps() {
        IEventBus modBus = FMLJavaModLoadingContext.get().getModEventBus();
        IEventBus forgeBus = MinecraftForge.EVENT_BUS;
        DistExecutor.safeRunWhenOn((Dist)Dist.CLIENT, () -> ClumpsClient::register);
        DEFERRED_REGISTER.register(modBus);
        modBus.addListener(this::setup);
        forgeBus.addListener(this::joinWorld);
        forgeBus.addListener(this::update);
    }

    private void setup(FMLCommonSetupEvent e) {
        ObfuscationReflectionHelper.setPrivateValue(EntityType.class, (Object)BIG_ORB_ENTITY_TYPE.get(), (Object)EntityType.field_200807_u.func_210760_d(), (String)"field_210762_aX");
    }

    private void update(TickEvent.WorldTickEvent e) {
        if (e.world.field_72995_K || e.phase == TickEvent.Phase.START) {
            return;
        }
        if (e.world instanceof ServerWorld && !orbs.isEmpty()) {
            Iterator<ExperienceOrbEntity> it = orbs.iterator();
            while (it.hasNext()) {
                ExperienceOrbEntity entity = it.next();
                HashMap<Integer, Long> clumpedMap = new HashMap<Integer, Long>();
                clumpedMap.put(entity.field_70530_e, 1L);
                EntityXPOrbBig bigOrb = new EntityXPOrbBig(entity.func_130014_f_(), entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_(), entity.field_70530_e, clumpedMap);
                MinecraftForge.EVENT_BUS.post((Event)new EXPCloneEvent(entity, bigOrb));
                bigOrb.func_213317_d(entity.func_213322_ci());
                entity.func_130014_f_().func_217376_c((Entity)bigOrb);
                entity.func_70106_y();
                it.remove();
            }
        }
    }

    private void joinWorld(EntityJoinWorldEvent e) {
        if (e.getEntity() instanceof ExperienceOrbEntity && e.getEntity().func_200600_R() != BIG_ORB_ENTITY_TYPE.get()) {
            World world = e.getEntity().field_70170_p;
            if (!world.field_72995_K) {
                orbs.add((ExperienceOrbEntity)e.getEntity());
            }
        }
    }
}

