/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.loot.condition;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import net.darkhax.bookshelf.Bookshelf;
import net.minecraft.loot.ILootSerializer;
import net.minecraft.loot.LootConditionType;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootParameters;
import net.minecraft.loot.conditions.ILootCondition;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;

public class CheckBiomeTag
implements ILootCondition {
    public static final Serializer SERIALIZER = new Serializer();
    private final BiomeDictionary.Type biomeType;

    public CheckBiomeTag(BiomeDictionary.Type type) {
        this.biomeType = type;
    }

    public boolean test(LootContext ctx) {
        Biome biome;
        Vector3d pos = (Vector3d)ctx.func_216031_c(LootParameters.field_237457_g_);
        if (pos != null && (biome = ctx.func_202879_g().func_226691_t_(new BlockPos(pos))) != null) {
            RegistryKey biomeKey = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239720_u_, (ResourceLocation)biome.getRegistryName());
            return BiomeDictionary.hasType((RegistryKey)biomeKey, (BiomeDictionary.Type)this.biomeType);
        }
        return false;
    }

    public LootConditionType func_230419_b_() {
        return Bookshelf.instance.conditionCheckBiomeTag;
    }

    static class Serializer
    implements ILootSerializer<CheckBiomeTag> {
        Serializer() {
        }

        public void serialize(JsonObject json, CheckBiomeTag value, JsonSerializationContext context) {
            json.addProperty("tag", value.biomeType.getName());
        }

        public CheckBiomeTag deserialize(JsonObject json, JsonDeserializationContext context) {
            BiomeDictionary.Type tag = BiomeDictionary.Type.getType((String)JSONUtils.func_151200_h((JsonObject)json, (String)"tag"), (BiomeDictionary.Type[])new BiomeDictionary.Type[0]);
            return new CheckBiomeTag(tag);
        }
    }
}

