/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.overlay;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.awt.Rectangle;
import mcp.mobius.waila.Waila;
import mcp.mobius.waila.WailaClient;
import mcp.mobius.waila.addons.core.PluginCore;
import mcp.mobius.waila.api.event.WailaRenderEvent;
import mcp.mobius.waila.api.impl.DataAccessor;
import mcp.mobius.waila.api.impl.config.PluginConfig;
import mcp.mobius.waila.api.impl.config.WailaConfig;
import mcp.mobius.waila.overlay.DisplayUtil;
import mcp.mobius.waila.overlay.RayTracing;
import mcp.mobius.waila.overlay.Tooltip;
import mcp.mobius.waila.overlay.WailaTickHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.entity.player.ChatVisibility;
import net.minecraft.util.math.RayTraceResult;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import org.lwjgl.opengl.GL11;

public class OverlayRenderer {
    protected static boolean hasLight;
    protected static boolean hasDepthTest;
    protected static boolean hasLight0;
    protected static boolean hasLight1;
    protected static boolean hasRescaleNormal;
    protected static boolean hasColorMaterial;
    protected static boolean depthMask;
    protected static int depthFunc;

    public static void renderOverlay() {
        boolean isOnServer;
        if (WailaTickHandler.instance().tooltip == null) {
            return;
        }
        if (!Waila.CONFIG.get().getGeneral().shouldDisplayTooltip()) {
            return;
        }
        if (Waila.CONFIG.get().getGeneral().getDisplayMode() == WailaConfig.DisplayMode.HOLD_KEY && !WailaClient.showOverlay.getKeyBinding().func_151468_f()) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71462_r != null && mc.field_71474_y.field_74343_n != ChatVisibility.HIDDEN || mc.field_71441_e == null) {
            return;
        }
        assert (mc.field_71439_g != null);
        boolean bl = isOnServer = !mc.func_71356_B() || mc.field_71439_g.field_71174_a.func_175106_d().size() > 1;
        if (Waila.CONFIG.get().getGeneral().shouldHideFromPlayerList() && mc.field_71474_y.field_74321_H.func_151468_f() && isOnServer) {
            return;
        }
        if (!Minecraft.func_71382_s()) {
            return;
        }
        if (mc.field_71474_y.field_74330_P && Waila.CONFIG.get().getGeneral().shouldHideFromDebug()) {
            return;
        }
        if (RayTracing.INSTANCE.getTarget() == null) {
            return;
        }
        if (RayTracing.INSTANCE.getTarget().func_216346_c() == RayTraceResult.Type.BLOCK && !RayTracing.INSTANCE.getTargetStack().func_190926_b()) {
            OverlayRenderer.renderOverlay(WailaTickHandler.instance().tooltip);
        }
        if (RayTracing.INSTANCE.getTarget().func_216346_c() == RayTraceResult.Type.ENTITY && PluginConfig.INSTANCE.get(PluginCore.CONFIG_SHOW_ENTITY)) {
            OverlayRenderer.renderOverlay(WailaTickHandler.instance().tooltip);
        }
    }

    public static void enableGUIStandardItemLighting() {
        RenderSystem.pushMatrix();
        RenderSystem.rotatef((float)-30.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        RenderSystem.rotatef((float)165.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        RenderHelper.func_227780_a_();
        RenderSystem.popMatrix();
    }

    public static void renderOverlay(Tooltip tooltip) {
        Minecraft.func_71410_x().func_213239_aq().func_76320_a("Waila Overlay");
        RenderSystem.pushMatrix();
        OverlayRenderer.saveGLState();
        RenderSystem.scalef((float)Waila.CONFIG.get().getOverlay().getOverlayScale(), (float)Waila.CONFIG.get().getOverlay().getOverlayScale(), (float)1.0f);
        RenderSystem.disableRescaleNormal();
        RenderHelper.func_74518_a();
        RenderSystem.disableLighting();
        RenderSystem.disableDepthTest();
        WailaRenderEvent.Pre preEvent = new WailaRenderEvent.Pre(DataAccessor.INSTANCE, tooltip.getPosition());
        if (MinecraftForge.EVENT_BUS.post((Event)preEvent)) {
            OverlayRenderer.enableGUIStandardItemLighting();
            RenderSystem.enableRescaleNormal();
            OverlayRenderer.loadGLState();
            RenderSystem.enableDepthTest();
            RenderSystem.popMatrix();
            return;
        }
        Rectangle position = preEvent.getPosition();
        WailaConfig.ConfigOverlay.ConfigOverlayColor color = Waila.CONFIG.get().getOverlay().getColor();
        WailaRenderEvent.Color colorEvent = new WailaRenderEvent.Color(color.getAlpha(), color.getBackgroundColor(), color.getGradientStart(), color.getGradientEnd());
        MinecraftForge.EVENT_BUS.post((Event)colorEvent);
        OverlayRenderer.drawTooltipBox(position.x, position.y, position.width, position.height, colorEvent.getBackground(), colorEvent.getGradientStart(), colorEvent.getGradientEnd());
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        tooltip.draw();
        RenderSystem.disableBlend();
        if (tooltip.hasItem()) {
            OverlayRenderer.enableGUIStandardItemLighting();
        }
        RenderSystem.enableRescaleNormal();
        if (tooltip.hasItem()) {
            DisplayUtil.renderStack(position.x + 5, position.y + position.height / 2 - 8, RayTracing.INSTANCE.getIdentifierStack());
        }
        WailaRenderEvent.Post postEvent = new WailaRenderEvent.Post(position);
        MinecraftForge.EVENT_BUS.post((Event)postEvent);
        OverlayRenderer.loadGLState();
        RenderSystem.enableDepthTest();
        RenderSystem.popMatrix();
        Minecraft.func_71410_x().func_213239_aq().func_76319_b();
    }

    public static void saveGLState() {
        hasLight = GL11.glGetBoolean((int)2896);
        hasLight0 = GL11.glGetBoolean((int)16384);
        hasLight1 = GL11.glGetBoolean((int)16385);
        hasDepthTest = GL11.glGetBoolean((int)2929);
        hasRescaleNormal = GL11.glGetBoolean((int)32826);
        hasColorMaterial = GL11.glGetBoolean((int)2903);
        depthFunc = GL11.glGetInteger((int)2932);
        depthMask = GL11.glGetBoolean((int)2930);
        GL11.glPushAttrib((int)1);
    }

    public static void loadGLState() {
        RenderSystem.depthMask((boolean)depthMask);
        RenderSystem.depthFunc((int)depthFunc);
        if (hasLight) {
            RenderSystem.enableLighting();
        } else {
            RenderSystem.disableLighting();
        }
        if (hasLight0) {
            GlStateManager.func_227638_a_((int)0);
        } else if (hasLight1) {
            GlStateManager.func_227638_a_((int)1);
        } else if (hasDepthTest) {
            RenderSystem.enableDepthTest();
        } else {
            RenderSystem.disableDepthTest();
        }
        if (hasRescaleNormal) {
            RenderSystem.enableRescaleNormal();
        } else {
            RenderSystem.disableRescaleNormal();
        }
        if (hasColorMaterial) {
            RenderSystem.enableColorMaterial();
        } else {
            RenderSystem.disableColorMaterial();
        }
        RenderSystem.popAttributes();
    }

    public static void drawTooltipBox(int x, int y, int w, int h, int bg, int grad1, int grad2) {
        DisplayUtil.drawGradientRect(x + 1, y, w - 1, 1, bg, bg);
        DisplayUtil.drawGradientRect(x + 1, y + h, w - 1, 1, bg, bg);
        DisplayUtil.drawGradientRect(x + 1, y + 1, w - 1, h - 1, bg, bg);
        DisplayUtil.drawGradientRect(x, y + 1, 1, h - 1, bg, bg);
        DisplayUtil.drawGradientRect(x + w, y + 1, 1, h - 1, bg, bg);
        DisplayUtil.drawGradientRect(x + 1, y + 2, 1, h - 3, grad1, grad2);
        DisplayUtil.drawGradientRect(x + w - 1, y + 2, 1, h - 3, grad1, grad2);
        DisplayUtil.drawGradientRect(x + 1, y + 1, w - 1, 1, grad1, grad1);
        DisplayUtil.drawGradientRect(x + 1, y + h - 1, w - 1, 1, grad2, grad2);
    }
}

