/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.common.config;

import java.util.EnumMap;
import java.util.Map;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.commons.lang3.tuple.Pair;
import slimeknights.tconstruct.world.TinkerHeadType;
import slimeknights.tconstruct.world.TinkerStructures;

public class Config {
    public static final ForgeConfigSpec clientSpec;
    public static final Client CLIENT;
    public static final ForgeConfigSpec commonSpec;
    public static final Common COMMON;

    public static void init() {
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, commonSpec);
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, clientSpec);
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        bus.addListener(Config::configChanged);
    }

    private static void configChanged(ModConfig.Reloading event) {
        ForgeConfigSpec spec;
        ModConfig config = event.getConfig();
        if (config.getModId().equals("tconstruct") && (spec = config.getSpec()) == commonSpec) {
            TinkerStructures.addStructureSeparation();
        }
    }

    static {
        Pair specPair = new ForgeConfigSpec.Builder().configure(Client::new);
        clientSpec = (ForgeConfigSpec)specPair.getRight();
        CLIENT = (Client)specPair.getLeft();
        specPair = new ForgeConfigSpec.Builder().configure(Common::new);
        commonSpec = (ForgeConfigSpec)specPair.getRight();
        COMMON = (Common)specPair.getLeft();
    }

    public static class Client {
        public final ForgeConfigSpec.BooleanValue tankFluidModel;
        public final ForgeConfigSpec.BooleanValue extraToolTips;
        public final ForgeConfigSpec.BooleanValue logMissingMaterialTextures;
        public final ForgeConfigSpec.BooleanValue logMissingModifierTextures;

        Client(ForgeConfigSpec.Builder builder) {
            builder.comment("Client only settings").push("client");
            this.tankFluidModel = builder.comment(new String[]{"Experimental. If true, renders fluids in tanks using a dynamic model, being more efficient when the tank is static", "If false, renders fluids in tanks using a TESR, which is more efficient when the tank contents are changing"}).translation("tconstruct.configgui.tankFluidModel").define("tankFluidModel", false);
            this.extraToolTips = builder.comment("If true tools will show additional info in their tooltips").translation("tconstruct.configgui.extraToolTips").define("extraToolTips", true);
            this.logMissingMaterialTextures = builder.comment("If true, the game will log all material textures which do not exist in resource packs but can be added, can be helpful for moddevs or resourcepack makers").translation("tconstruct.configgui.logMissingMaterialTextures").define("logMissingMaterialTextures", false);
            this.logMissingModifierTextures = builder.comment("If true, the game will log all modifier textures which do not exist in resource packs but can be added, can be helpful for moddevs or resourcepack makers").translation("tconstruct.configgui.logMissingMaterialTextures").define("logMissingModifierTextures", false);
            builder.pop();
        }
    }

    public static class Common {
        public final ForgeConfigSpec.BooleanValue shouldSpawnWithTinkersBook;
        public final ForgeConfigSpec.BooleanValue addGravelToFlintRecipe;
        public final ForgeConfigSpec.BooleanValue cheaperNetheriteAlloy;
        public final ForgeConfigSpec.BooleanValue witherBoneDrop;
        public final ForgeConfigSpec.BooleanValue witherBoneConversion;
        public final ForgeConfigSpec.BooleanValue glassRecipeFix;
        public final Map<TinkerHeadType, ForgeConfigSpec.BooleanValue> headDrops;
        public final ForgeConfigSpec.ConfigValue<Integer> melterNuggetsPerOre;
        public final ForgeConfigSpec.ConfigValue<Integer> smelteryNuggetsPerOre;
        public final ForgeConfigSpec.ConfigValue<Integer> foundryNuggetsPerOre;
        public final ForgeConfigSpec.BooleanValue generateCobalt;
        public final ForgeConfigSpec.ConfigValue<Integer> veinCountCobalt;
        public final ForgeConfigSpec.BooleanValue generateCopper;
        public final ForgeConfigSpec.ConfigValue<Integer> veinCountCopper;
        public final ForgeConfigSpec.BooleanValue generateEarthSlimeIslands;
        public final ForgeConfigSpec.BooleanValue generateSkySlimeIslands;
        public final ForgeConfigSpec.BooleanValue generateClayIslands;
        public final ForgeConfigSpec.IntValue earthSlimeIslandSeparation;
        public final ForgeConfigSpec.IntValue skySlimeIslandSeparation;
        public final ForgeConfigSpec.IntValue clayIslandSeparation;
        public final ForgeConfigSpec.BooleanValue generateBloodIslands;
        public final ForgeConfigSpec.IntValue bloodIslandSeparation;
        public final ForgeConfigSpec.BooleanValue generateEndSlimeIslands;
        public final ForgeConfigSpec.IntValue endSlimeIslandSeparation;
        public final ForgeConfigSpec.ConfigValue<String> showOnlyToolMaterial;
        public final ForgeConfigSpec.ConfigValue<String> showOnlyPartMaterial;
        public final ForgeConfigSpec.BooleanValue showAllTableVariants;
        public final ForgeConfigSpec.BooleanValue showAllAnvilVariants;
        public final ForgeConfigSpec.BooleanValue forceIntegrationMaterials;

        Common(ForgeConfigSpec.Builder builder) {
            builder.comment("Everything to do with gameplay").push("gameplay");
            this.shouldSpawnWithTinkersBook = builder.comment("Set this to false to disable new players spawning with the Tinkers' Book.").translation("tconstruct.configgui.shouldSpawnWithTinkersBook").worldRestart().define("shouldSpawnWithTinkersBook", true);
            this.showOnlyToolMaterial = builder.comment(new String[]{"If non-empty, only this material will be shown on tools in creative and JEI (or the first valid material if this is invalid for the tool).", "If empty, all materials will show"}).translation("tconstruct.configgui.showOnlyToolMaterial").worldRestart().define("showOnlyToolMaterial", (Object)"");
            this.showOnlyPartMaterial = builder.comment(new String[]{"If non-empty, only material will be shown on parts in creative and JEI (or the first valid material if this is invalid for the part).", "If empty, all materials will show"}).translation("tconstruct.configgui.showOnlyPartMaterial").worldRestart().define("showOnlyPartMaterial", (Object)"");
            this.showAllTableVariants = builder.comment("If true, tables such as the part builder and tinker station will show all variants. If false they will show just the first entry in the tag, typically oak.").translation("tconstruct.configgui.showAllTableVariants").define("showAllTableVariants", true);
            this.showAllAnvilVariants = builder.comment("If true, anvils will show all metal variants. If false, only the first variant in the tag will show (typically tinkers bronze)").translation("tconstruct.configgui.showAllAnvilVariants").define("showAllAnvilVariants", true);
            builder.pop();
            builder.comment("Options related to recipes, limited options as a datapack allows most recipes to be modified").push("recipes");
            this.addGravelToFlintRecipe = builder.comment("Add a recipe that allows you to craft a piece of flint using 3 gravel").translation("tconstruct.configgui.addGravelToFlintRecipe").worldRestart().define("addGravelToFlintRecipe", true);
            this.cheaperNetheriteAlloy = builder.comment("Makes the recipe to alloy netherite in the smeltery only cost 2 gold per netherite ingot. If false uses the vanilla rate of 4 gold per ingot. Disable if there are crafting duplications.").translation("tconstruct.configgui.cheaperNetheriteAlloy").worldRestart().define("cheaperNetheriteAlloy", true);
            this.witherBoneDrop = builder.comment("Makes wither skeletons drop necrotic bones").translation("tconstruct.configgui.witherBoneDrop").worldRestart().define("witherBoneDrop", true);
            this.witherBoneConversion = builder.comment("Allows converting wither bones to regular bones").translation("tconstruct.configgui.witherBoneConversion").worldRestart().define("witherBoneConversion", true);
            this.glassRecipeFix = builder.comment("Fixes clear glass not being usable in vanilla recipes that require glass. Config option exists to disable easily in case this fix is redundant to another mod").translation("tconstruct.configgui.glassRecipeFix").worldRestart().define("glassRecipeFix", true);
            this.melterNuggetsPerOre = builder.comment("Number of nuggets produced when an ore block is melted in the melter. 9 would give 1 ingot").translation("tconstruct.configgui.melterNuggetsPerOre").defineInRange("melterNuggetsPerOre", 12, 1, 45);
            this.smelteryNuggetsPerOre = builder.comment("Number of nuggets produced when an ore block is melted in the smeltery. 9 nuggets would give 1 ingot").translation("tconstruct.configgui.smelteryNuggetsPerOre").defineInRange("smelteryNuggetsPerOre", 18, 1, 45);
            this.foundryNuggetsPerOre = builder.comment("Number of nuggets produced when an ore block is melted in the foundry. 9 nuggets would give 1 ingot").translation("tconstruct.configgui.foundryNuggetsPerOre").defineInRange("foundryNuggetsPerOre", 15, 1, 45);
            builder.comment("Entity head drops when killed by a charged creeper").push("heads");
            this.headDrops = new EnumMap<TinkerHeadType, ForgeConfigSpec.BooleanValue>(TinkerHeadType.class);
            for (TinkerHeadType headType : TinkerHeadType.values()) {
                this.headDrops.put(headType, builder.translation("tconstruct.configgui.heads." + headType.func_176610_l()).define(headType.func_176610_l(), true));
            }
            builder.pop(2);
            builder.comment("Everything to do with world generation").push("worldgen");
            this.generateCopper = builder.comment("Generate Copper").translation("tconstruct.configgui.generateCopper").worldRestart().define("generateCopper", true);
            this.veinCountCopper = builder.comment("Approx Ores per Chunk").translation("tconstruct.configgui.veinCountCopper").worldRestart().define("veinCountCopper", (Object)20);
            this.generateCobalt = builder.comment("Generate Cobalt").translation("tconstruct.configgui.generateCobalt").worldRestart().define("generateCobalt", true);
            this.veinCountCobalt = builder.comment("Approx Ores per Chunk").translation("tconstruct.configgui.veinCountCobalt").worldRestart().define("veinCountCobalt", (Object)8);
            builder.comment("Options related to slime islands").push("slime_islands");
            builder.comment("Options related to earth slime islands spawning in the oceans").push("earth");
            this.generateEarthSlimeIslands = builder.comment("If true, this island generates").worldRestart().define("generate", true);
            this.earthSlimeIslandSeparation = builder.comment("How many chunks on average between islands").worldRestart().defineInRange("separation", 25, 10, 500);
            builder.pop();
            builder.comment("Settings for sky slime islands in the overworld sky").push("sky");
            this.generateSkySlimeIslands = builder.comment("If true, this island generates").worldRestart().define("generate", true);
            this.skySlimeIslandSeparation = builder.comment("How many chunks on average between islands").worldRestart().defineInRange("separation", 30, 10, 500);
            builder.pop();
            builder.comment("Settings for clay islands in the overworld sky").push("clay");
            this.generateClayIslands = builder.comment("If true, this island generates").worldRestart().define("generate", true);
            this.clayIslandSeparation = builder.comment("How many chunks on average between islands").worldRestart().defineInRange("separation", 100, 10, 500);
            builder.pop();
            builder.comment("Settings for blood islands in the nether lava ocean").push("blood");
            this.generateBloodIslands = builder.comment("If true, this island generates").worldRestart().define("generate", true);
            this.bloodIslandSeparation = builder.comment("How many chunks on average between islands").worldRestart().defineInRange("separation", 13, 10, 500);
            builder.pop();
            builder.comment("Settings for end slime islands in the outer end islands").push("end");
            this.generateEndSlimeIslands = builder.comment("If true, this island generates").worldRestart().define("generate", true);
            this.endSlimeIslandSeparation = builder.comment("How many chunks on average between islands").worldRestart().defineInRange("separation", 25, 10, 500);
            builder.pop(2);
            builder.pop();
            builder.comment("Features to use in debugging gameplay and mechanics, generally should not be enabled in packs").push("debug");
            this.forceIntegrationMaterials = builder.comment(new String[]{"If true, forces integration materials to be enabled, even if the relevant metal is missing. Useful for testing material balance.", "Does not provide recipes for any of them, they will only be available to cheat in creative."}).worldRestart().define("forceIntegrationMaterials", false);
            builder.pop();
        }
    }
}

