/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.book;

import net.minecraft.util.ResourceLocation;
import slimeknights.mantle.client.book.BookLoader;
import slimeknights.mantle.client.book.BookTransformer;
import slimeknights.mantle.client.book.data.BookData;
import slimeknights.mantle.client.book.repository.BookRepository;
import slimeknights.mantle.client.book.repository.FileRepository;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.book.content.ContentImageText2;
import slimeknights.tconstruct.library.book.content.ContentIndex;
import slimeknights.tconstruct.library.book.content.ContentMaterial;
import slimeknights.tconstruct.library.book.content.ContentModifier;
import slimeknights.tconstruct.library.book.content.ContentPadding;
import slimeknights.tconstruct.library.book.content.ContentShowcase;
import slimeknights.tconstruct.library.book.content.ContentTextTinkers;
import slimeknights.tconstruct.library.book.content.ContentTool;
import slimeknights.tconstruct.library.book.sectiontransformer.ModifierSectionTransformer;
import slimeknights.tconstruct.library.book.sectiontransformer.ToolSectionTransformer;
import slimeknights.tconstruct.library.book.sectiontransformer.materials.TieredMaterialSectionTransformer;
import slimeknights.tconstruct.shared.item.TinkerBookItem;

public class TinkerBook
extends BookData {
    private static final ResourceLocation MATERIALS_BOOK_ID = TConstruct.getResource("materials_and_you");
    private static final ResourceLocation MIGHTY_SMELTING_ID = TConstruct.getResource("mighty_smelting");
    private static final ResourceLocation PUNY_SMELTING_ID = TConstruct.getResource("puny_smelting");
    private static final ResourceLocation TINKERS_GADGETRY_ID = TConstruct.getResource("tinkers_gadgetry");
    private static final ResourceLocation FANTASTIC_FOUNDRY_ID = TConstruct.getResource("fantastic_foundry");
    private static final ResourceLocation ENCYCLOPEDIA_ID = TConstruct.getResource("encyclopedia");
    public static final BookData MATERIALS_AND_YOU = BookLoader.registerBook((String)MATERIALS_BOOK_ID.toString(), (boolean)false, (boolean)false, (BookRepository[])new BookRepository[0]);
    public static final BookData PUNY_SMELTING = BookLoader.registerBook((String)MIGHTY_SMELTING_ID.toString(), (boolean)false, (boolean)false, (BookRepository[])new BookRepository[0]);
    public static final BookData MIGHTY_SMELTING = BookLoader.registerBook((String)MIGHTY_SMELTING_ID.toString(), (boolean)false, (boolean)false, (BookRepository[])new BookRepository[0]);
    public static final BookData TINKERS_GADGETRY = BookLoader.registerBook((String)TINKERS_GADGETRY_ID.toString(), (boolean)false, (boolean)false, (BookRepository[])new BookRepository[0]);
    public static final BookData FANTASTIC_FOUNDRY = BookLoader.registerBook((String)FANTASTIC_FOUNDRY_ID.toString(), (boolean)false, (boolean)false, (BookRepository[])new BookRepository[0]);
    public static final BookData ENCYCLOPEDIA = BookLoader.registerBook((String)ENCYCLOPEDIA_ID.toString(), (boolean)false, (boolean)false, (BookRepository[])new BookRepository[0]);

    public TinkerBook() {
        super(new BookRepository[0]);
    }

    public static void initBook() {
        BookLoader.registerPageType((String)"tinkers_text", ContentTextTinkers.class);
        BookLoader.registerPageType((String)"imageText2", ContentImageText2.class);
        BookLoader.registerPageType((String)"toolmaterial", ContentMaterial.class);
        BookLoader.registerPageType((String)"tool", ContentTool.class);
        BookLoader.registerPageType((String)"modifier", ContentModifier.class);
        BookLoader.registerPageType((String)"index", ContentIndex.class);
        BookLoader.registerPageType((String)"showcase", ContentShowcase.class);
        BookLoader.registerPageType((String)"left_padding", ContentPadding.ContentLeftPadding.class);
        BookLoader.registerPageType((String)"right_padding", ContentPadding.ContentRightPadding.class);
        MATERIALS_AND_YOU.addTransformer((BookTransformer)ToolSectionTransformer.INSTANCE);
        MIGHTY_SMELTING.addTransformer((BookTransformer)ToolSectionTransformer.INSTANCE);
        ENCYCLOPEDIA.addTransformer((BookTransformer)new ToolSectionTransformer("small_tools"));
        ENCYCLOPEDIA.addTransformer((BookTransformer)new ToolSectionTransformer("large_tools"));
        MATERIALS_AND_YOU.addTransformer((BookTransformer)new TieredMaterialSectionTransformer("tier_one_materials", 1, false));
        PUNY_SMELTING.addTransformer((BookTransformer)new TieredMaterialSectionTransformer("tier_two_materials", 2, false));
        MIGHTY_SMELTING.addTransformer((BookTransformer)new TieredMaterialSectionTransformer("tier_three_materials", 3, false));
        FANTASTIC_FOUNDRY.addTransformer((BookTransformer)new TieredMaterialSectionTransformer("tier_four_materials", 4, false));
        ENCYCLOPEDIA.addTransformer((BookTransformer)new TieredMaterialSectionTransformer("tier_one_materials", 1, true));
        ENCYCLOPEDIA.addTransformer((BookTransformer)new TieredMaterialSectionTransformer("tier_two_materials", 2, true));
        ENCYCLOPEDIA.addTransformer((BookTransformer)new TieredMaterialSectionTransformer("tier_three_materials", 3, true));
        ENCYCLOPEDIA.addTransformer((BookTransformer)new TieredMaterialSectionTransformer("tier_four_materials", 4, true));
        ModifierSectionTransformer upgrades = new ModifierSectionTransformer("upgrades");
        ModifierSectionTransformer slotless = new ModifierSectionTransformer("slotless");
        ModifierSectionTransformer abilities = new ModifierSectionTransformer("abilities");
        PUNY_SMELTING.addTransformer((BookTransformer)upgrades);
        PUNY_SMELTING.addTransformer((BookTransformer)slotless);
        MIGHTY_SMELTING.addTransformer((BookTransformer)abilities);
        ENCYCLOPEDIA.addTransformer((BookTransformer)upgrades);
        ENCYCLOPEDIA.addTransformer((BookTransformer)slotless);
        ENCYCLOPEDIA.addTransformer((BookTransformer)abilities);
        TinkerBook.addStandardData(MATERIALS_AND_YOU, MATERIALS_BOOK_ID);
        TinkerBook.addStandardData(PUNY_SMELTING, PUNY_SMELTING_ID);
        TinkerBook.addStandardData(MIGHTY_SMELTING, MIGHTY_SMELTING_ID);
        TinkerBook.addStandardData(FANTASTIC_FOUNDRY, FANTASTIC_FOUNDRY_ID);
        TinkerBook.addStandardData(TINKERS_GADGETRY, TINKERS_GADGETRY_ID);
        TinkerBook.addStandardData(ENCYCLOPEDIA, ENCYCLOPEDIA_ID);
    }

    private static void addStandardData(BookData book, ResourceLocation id) {
        book.addRepository((BookRepository)new FileRepository(id.func_110624_b() + ":book/" + id.func_110623_a()));
        book.addTransformer(BookTransformer.indexTranformer());
        book.addTransformer((BookTransformer)ContentPadding.PaddingBookTransformer.INSTANCE);
    }

    public static BookData getBook(TinkerBookItem.BookType bookType) {
        switch (bookType) {
            default: {
                return MATERIALS_AND_YOU;
            }
            case PUNY_SMELTING: {
                return PUNY_SMELTING;
            }
            case MIGHTY_SMELTING: {
                return MIGHTY_SMELTING;
            }
            case TINKERS_GADGETRY: {
                return TINKERS_GADGETRY;
            }
            case FANTASTIC_FOUNDRY: {
                return FANTASTIC_FOUNDRY;
            }
            case ENCYCLOPEDIA: 
        }
        return ENCYCLOPEDIA;
    }
}

