/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.book.sectiontransformer.materials;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.RecipeManager;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import slimeknights.mantle.client.book.data.BookData;
import slimeknights.mantle.client.book.data.PageData;
import slimeknights.mantle.client.book.data.SectionData;
import slimeknights.mantle.client.book.data.content.PageContent;
import slimeknights.mantle.client.book.repository.BookRepository;
import slimeknights.mantle.client.screen.book.element.ItemElement;
import slimeknights.mantle.client.screen.book.element.SizedBookElement;
import slimeknights.mantle.recipe.RecipeHelper;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.book.content.ContentMaterial;
import slimeknights.tconstruct.library.book.content.ContentPageIconList;
import slimeknights.tconstruct.library.book.sectiontransformer.SectionTransformer;
import slimeknights.tconstruct.library.materials.MaterialRegistry;
import slimeknights.tconstruct.library.materials.definition.IMaterial;
import slimeknights.tconstruct.library.recipe.RecipeTypes;
import slimeknights.tconstruct.library.recipe.material.MaterialRecipe;
import slimeknights.tconstruct.tools.TinkerToolParts;
import slimeknights.tconstruct.tools.item.RepairKitItem;

@OnlyIn(value=Dist.CLIENT)
public abstract class AbstractMaterialSectionTransformer
extends SectionTransformer {
    private final boolean detailed;

    public AbstractMaterialSectionTransformer(String sectionName, boolean detailed) {
        super(sectionName);
        this.detailed = detailed;
    }

    protected abstract boolean isValidMaterial(IMaterial var1);

    protected PageContent getPageContent(IMaterial material, List<ItemStack> displayStacks) {
        return new ContentMaterial(material, displayStacks, this.detailed);
    }

    @Override
    public void transform(BookData book, SectionData sectionData) {
        sectionData.source = BookRepository.DUMMY;
        sectionData.parent = book;
        List materialList = MaterialRegistry.getMaterials().stream().filter(this::isValidMaterial).collect(Collectors.toList());
        if (materialList.isEmpty()) {
            return;
        }
        List<ContentPageIconList> listPages = ContentPageIconList.getPagesNeededForItemCount(materialList.size(), sectionData, book.translate(this.sectionName), (String)book.strings.get(String.format("%s.subtext", this.sectionName)));
        ListIterator<ContentPageIconList> iter = listPages.listIterator();
        ContentPageIconList overview = iter.next();
        for (IMaterial material : materialList) {
            assert (Minecraft.func_71410_x().field_71441_e != null);
            List recipes = RecipeHelper.getUIRecipes((RecipeManager)Minecraft.func_71410_x().field_71441_e.func_199532_z(), RecipeTypes.MATERIAL, MaterialRecipe.class, recipe -> recipe.getMaterial() == material);
            ArrayList<ItemStack> displayStacks = new ArrayList<ItemStack>();
            for (MaterialRecipe recipe2 : recipes) {
                displayStacks.addAll(recipe2.getDisplayItems());
            }
            if (displayStacks.isEmpty()) {
                TConstruct.LOG.debug("Material with id " + (Object)((Object)material.getIdentifier()) + " has no representation items associated with it, using repair kit");
                displayStacks.add(((RepairKitItem)TinkerToolParts.repairKit.get()).withMaterialForDisplay(material.getIdentifier()));
            }
            PageData page = this.addPage(sectionData, material.getIdentifier().toString(), "toolmaterial", this.getPageContent(material, displayStacks));
            ItemElement icon = new ItemElement(0, 0, 1.0f, displayStacks);
            while (!overview.addLink((SizedBookElement)icon, (ITextComponent)new TranslationTextComponent(material.getTranslationKey()).func_240700_a_(style -> style.func_240718_a_(material.getColor())), page)) {
                overview = iter.next();
            }
        }
    }
}

