/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.book.sectiontransformer.materials;

import com.google.common.collect.ImmutableList;
import java.util.List;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import slimeknights.tconstruct.library.book.sectiontransformer.materials.AbstractMaterialSectionTransformer;
import slimeknights.tconstruct.library.materials.IMaterialRegistry;
import slimeknights.tconstruct.library.materials.MaterialRegistry;
import slimeknights.tconstruct.library.materials.definition.IMaterial;
import slimeknights.tconstruct.library.materials.definition.MaterialId;
import slimeknights.tconstruct.library.materials.stats.MaterialStatsId;
import slimeknights.tconstruct.tools.stats.ExtraMaterialStats;
import slimeknights.tconstruct.tools.stats.HandleMaterialStats;
import slimeknights.tconstruct.tools.stats.HeadMaterialStats;

@OnlyIn(value=Dist.CLIENT)
public class TieredMaterialSectionTransformer
extends AbstractMaterialSectionTransformer {
    private static final List<MaterialStatsId> VISIBLE_STATS = ImmutableList.of((Object)((Object)HeadMaterialStats.ID), (Object)((Object)HandleMaterialStats.ID), (Object)((Object)ExtraMaterialStats.ID));
    private final int materialTier;

    public TieredMaterialSectionTransformer(String sectionName, int materialTier, boolean detailed) {
        super(sectionName, detailed);
        this.materialTier = materialTier;
    }

    @Override
    protected boolean isValidMaterial(IMaterial material) {
        if (material.getTier() != this.materialTier) {
            return false;
        }
        MaterialId id = material.getIdentifier();
        IMaterialRegistry registry = MaterialRegistry.getInstance();
        for (MaterialStatsId stats : VISIBLE_STATS) {
            if (!registry.getMaterialStats(id, stats).isPresent()) continue;
            return true;
        }
        return false;
    }
}

