/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.client.modifiers;

import com.google.common.collect.ImmutableList;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.RenderMaterial;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.fluid.Fluid;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.TransformationMatrix;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.model.ItemTextureQuadConverter;
import net.minecraftforge.fluids.FluidAttributes;
import net.minecraftforge.fluids.FluidStack;
import slimeknights.mantle.util.ItemLayerPixels;
import slimeknights.tconstruct.library.client.modifiers.IUnbakedModifierModel;
import slimeknights.tconstruct.library.client.modifiers.NormalModifierModel;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.TankModifier;
import slimeknights.tconstruct.library.tools.nbt.IModifierToolStack;

public class FluidModifierModel
extends NormalModifierModel {
    public static final IUnbakedModifierModel UNBAKED_INSTANCE = (smallGetter, largeGetter) -> {
        RenderMaterial smallTexture = (RenderMaterial)smallGetter.apply("");
        RenderMaterial largeTexture = (RenderMaterial)largeGetter.apply("");
        RenderMaterial smallFull = (RenderMaterial)smallGetter.apply("_full");
        RenderMaterial largeFull = (RenderMaterial)largeGetter.apply("_full");
        if (smallTexture != null || largeTexture != null) {
            return new FluidModifierModel(smallTexture, largeTexture, smallFull, largeFull);
        }
        return null;
    };
    protected final RenderMaterial[] fluidTextures;

    protected FluidModifierModel(@Nullable RenderMaterial smallTexture, @Nullable RenderMaterial largeTexture, RenderMaterial[] fluidTextures) {
        super(smallTexture, largeTexture);
        this.fluidTextures = fluidTextures;
    }

    public FluidModifierModel(@Nullable RenderMaterial smallTexture, @Nullable RenderMaterial largeTexture, @Nullable RenderMaterial smallFull, @Nullable RenderMaterial largeFull) {
        this(smallTexture, largeTexture, new RenderMaterial[]{smallFull, largeFull});
    }

    @Override
    @Nullable
    public Object getCacheKey(IModifierToolStack tool, ModifierEntry entry) {
        TankModifier tank;
        FluidStack fluid;
        if (entry.getModifier() instanceof TankModifier && !(fluid = (tank = (TankModifier)entry.getModifier()).getFluid(tool)).isEmpty()) {
            return new FluidModifierCacheKey(tank, fluid.getFluid());
        }
        return entry.getModifier();
    }

    @Nullable
    protected RenderMaterial getTemplate(TankModifier tank, IModifierToolStack tool, FluidStack fluid, boolean isLarge) {
        return this.fluidTextures[isLarge ? 1 : 0];
    }

    @Override
    public ImmutableList<BakedQuad> getQuads(IModifierToolStack tool, ModifierEntry entry, Function<RenderMaterial, TextureAtlasSprite> spriteGetter, TransformationMatrix transforms, boolean isLarge, int startTintIndex, @Nullable ItemLayerPixels pixels) {
        RenderMaterial template;
        TankModifier tank;
        FluidStack fluid;
        ImmutableList quads = super.getQuads(tool, entry, spriteGetter, transforms, isLarge, startTintIndex, pixels);
        if (entry.getModifier() instanceof TankModifier && !(fluid = (tank = (TankModifier)entry.getModifier()).getFluid(tool)).isEmpty() && (template = this.getTemplate(tank, tool, fluid, isLarge)) != null) {
            ImmutableList.Builder builder = ImmutableList.builder();
            builder.addAll(quads);
            FluidAttributes attributes = fluid.getFluid().getAttributes();
            TextureAtlasSprite fluidSprite = spriteGetter.apply(ForgeHooksClient.getBlockMaterial((ResourceLocation)attributes.getStillTexture(fluid)));
            int color = attributes.getColor(fluid);
            int luminosity = attributes.getLuminosity(fluid);
            TextureAtlasSprite templateSprite = spriteGetter.apply(template);
            builder.addAll((Iterable)ItemTextureQuadConverter.convertTexture((TransformationMatrix)transforms, (TextureAtlasSprite)templateSprite, (TextureAtlasSprite)fluidSprite, (float)0.468625f, (Direction)Direction.NORTH, (int)color, (int)-1, (int)luminosity));
            builder.addAll((Iterable)ItemTextureQuadConverter.convertTexture((TransformationMatrix)transforms, (TextureAtlasSprite)templateSprite, (TextureAtlasSprite)fluidSprite, (float)0.531375f, (Direction)Direction.SOUTH, (int)color, (int)-1, (int)luminosity));
            quads = builder.build();
        }
        return quads;
    }

    private static class FluidModifierCacheKey {
        private final Modifier modifier;
        private final Fluid fluid;

        public FluidModifierCacheKey(Modifier modifier, Fluid fluid) {
            this.modifier = modifier;
            this.fluid = fluid;
        }

        public Modifier getModifier() {
            return this.modifier;
        }

        public Fluid getFluid() {
            return this.fluid;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof FluidModifierCacheKey)) {
                return false;
            }
            FluidModifierCacheKey other = (FluidModifierCacheKey)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Modifier this$modifier = this.getModifier();
            Modifier other$modifier = other.getModifier();
            if (this$modifier == null ? other$modifier != null : !this$modifier.equals(other$modifier)) {
                return false;
            }
            Fluid this$fluid = this.getFluid();
            Fluid other$fluid = other.getFluid();
            return !(this$fluid == null ? other$fluid != null : !this$fluid.equals(other$fluid));
        }

        protected boolean canEqual(Object other) {
            return other instanceof FluidModifierCacheKey;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Modifier $modifier = this.getModifier();
            result = result * 59 + ($modifier == null ? 43 : $modifier.hashCode());
            Fluid $fluid = this.getFluid();
            result = result * 59 + ($fluid == null ? 43 : $fluid.hashCode());
            return result;
        }

        public String toString() {
            return "FluidModifierModel.FluidModifierCacheKey(modifier=" + this.getModifier() + ", fluid=" + this.getFluid() + ")";
        }
    }
}

