/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.client.modifiers;

import com.google.common.collect.ImmutableMap;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.model.RenderMaterial;
import net.minecraft.resources.IFutureReloadListener;
import net.minecraft.resources.IReloadableResourceManager;
import net.minecraft.resources.IResource;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.ModLoader;
import net.minecraftforge.fml.event.lifecycle.IModBusEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import slimeknights.tconstruct.common.config.Config;
import slimeknights.tconstruct.library.TinkerRegistries;
import slimeknights.tconstruct.library.client.model.tools.MaterialModel;
import slimeknights.tconstruct.library.client.modifiers.IBakedModifierModel;
import slimeknights.tconstruct.library.client.modifiers.IUnbakedModifierModel;
import slimeknights.tconstruct.library.data.IEarlySafeManagerReloadListener;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.tools.TinkerModifiers;

public class ModifierModelManager
implements IEarlySafeManagerReloadListener {
    private static final Logger log = LogManager.getLogger(ModifierModelManager.class);
    private static final String VISIBLE_MODIFIERS = "models/tconstruct_modifiers.json";
    public static final ModifierModelManager INSTANCE = new ModifierModelManager();
    private static boolean eventFired = false;
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private static final Map<ResourceLocation, IUnbakedModifierModel> MODIFIER_MODEL_OPTIONS = new HashMap<ResourceLocation, IUnbakedModifierModel>();
    private static Map<Modifier, IUnbakedModifierModel> modifierModels = Collections.emptyMap();

    public static void init(IReloadableResourceManager manager) {
        manager.func_219534_a((IFutureReloadListener)INSTANCE);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    private static JsonObject getJson(IResource resource) {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(resource.func_199027_b(), StandardCharsets.UTF_8));){
            JsonObject jsonObject = JSONUtils.func_212743_a((Reader)reader);
            return jsonObject;
        }
        catch (JsonParseException | IOException e) {
            log.error("Failed to load texture JSON " + resource.func_199029_a(), e);
            return null;
        }
    }

    @Nullable
    private static IUnbakedModifierModel getLoader(String key, String name) {
        ResourceLocation loader = ResourceLocation.func_208304_a((String)name);
        if (loader == null) {
            log.error("Skipping modifier " + key + " as " + name + " is an invalid loader name");
        } else {
            IUnbakedModifierModel model = MODIFIER_MODEL_OPTIONS.get(loader);
            if (model == null) {
                log.error("Skipping modifier " + key + " as the loader " + loader + " is unknown");
            } else {
                return model;
            }
        }
        return null;
    }

    @Override
    public void onReloadSafe(IResourceManager manager) {
        if (!eventFired) {
            ModLoader.get().postEvent((Event)new ModifierModelRegistrationEvent());
            eventFired = true;
        }
        HashMap<Modifier, IUnbakedModifierModel> models = new HashMap<Modifier, IUnbakedModifierModel>();
        List jsonFiles = manager.func_199001_a().stream().flatMap(namespace -> {
            ResourceLocation location = new ResourceLocation(namespace, VISIBLE_MODIFIERS);
            try {
                return manager.func_199004_b(location).stream();
            }
            catch (FileNotFoundException fileNotFoundException) {
            }
            catch (IOException e) {
                log.error("Failed to load modifier models from {}", (Object)location, (Object)e);
            }
            return Stream.empty();
        }).map(ModifierModelManager::getJson).filter(Objects::nonNull).collect(Collectors.toList());
        for (int i = jsonFiles.size() - 1; i >= 0; --i) {
            JsonObject json = (JsonObject)jsonFiles.get(i);
            for (Map.Entry entry : json.entrySet()) {
                String key = (String)entry.getKey();
                ResourceLocation name = ResourceLocation.func_208304_a((String)key);
                if (name == null) {
                    log.error("Skipping invalid modifier key " + key + " as it is not a valid resource location");
                    continue;
                }
                Modifier modifier = (Modifier)TinkerRegistries.MODIFIERS.getValue(name);
                if (modifier == null || modifier == TinkerModifiers.empty.get()) {
                    log.error("Skipping unknown modifier " + key);
                    continue;
                }
                if (models.containsKey(modifier)) continue;
                JsonElement element = (JsonElement)entry.getValue();
                if (element.isJsonNull()) {
                    models.remove(modifier);
                    continue;
                }
                if (element.isJsonObject()) {
                    JsonObject object = element.getAsJsonObject();
                    IUnbakedModifierModel model = ModifierModelManager.getLoader(key, JSONUtils.func_151200_h((JsonObject)object, (String)"type"));
                    if (model == null) continue;
                    models.put(modifier, model.configure(object));
                    continue;
                }
                if (element.isJsonPrimitive()) {
                    IUnbakedModifierModel model = ModifierModelManager.getLoader(key, element.getAsString());
                    if (model == null) continue;
                    models.put(modifier, model);
                    continue;
                }
                log.error("Skipping key " + key + " as the value is not a string");
            }
        }
        modifierModels = models;
    }

    private static RenderMaterial getModifierTexture(ResourceLocation modifierRoot, ResourceLocation modifierId, String suffix) {
        return ForgeHooksClient.getBlockMaterial((ResourceLocation)new ResourceLocation(modifierRoot.func_110624_b(), modifierRoot.func_110623_a() + modifierId.func_110624_b() + "_" + modifierId.func_110623_a() + suffix));
    }

    @Nullable
    private static RenderMaterial getTexture(List<ResourceLocation> modifierRoots, @Nullable Predicate<RenderMaterial> textureAdder, ResourceLocation modifier, String suffix) {
        if (textureAdder == null) {
            return null;
        }
        for (ResourceLocation root : modifierRoots) {
            RenderMaterial texture = ModifierModelManager.getModifierTexture(root, modifier, suffix);
            if (!textureAdder.test(texture)) continue;
            return texture;
        }
        return null;
    }

    public static Map<Modifier, IBakedModifierModel> getModelsForTool(List<ResourceLocation> smallModifierRoots, List<ResourceLocation> largeModifierRoots, Collection<RenderMaterial> textures) {
        if (modifierModels.isEmpty() || smallModifierRoots.isEmpty() && largeModifierRoots.isEmpty()) {
            return Collections.emptyMap();
        }
        ImmutableMap.Builder modelMap = ImmutableMap.builder();
        Predicate<RenderMaterial> smallTextureAdder = smallModifierRoots.isEmpty() ? null : MaterialModel.getTextureAdder(smallModifierRoots.get(0), textures, (Boolean)Config.CLIENT.logMissingModifierTextures.get());
        Predicate<RenderMaterial> largeTextureAdder = largeModifierRoots.isEmpty() ? null : MaterialModel.getTextureAdder(largeModifierRoots.get(0), textures, (Boolean)Config.CLIENT.logMissingModifierTextures.get());
        for (Modifier modifier : TinkerRegistries.MODIFIERS.getValues()) {
            IBakedModifierModel toolModel;
            IUnbakedModifierModel model = modifierModels.get(modifier);
            if (model == null || (toolModel = model.forTool(name -> ModifierModelManager.getTexture(smallModifierRoots, smallTextureAdder, modifier.getId(), name), name -> ModifierModelManager.getTexture(largeModifierRoots, largeTextureAdder, modifier.getId(), name))) == null) continue;
            modelMap.put((Object)modifier, (Object)toolModel);
        }
        return modelMap.build();
    }

    private ModifierModelManager() {
    }

    public static class ModifierModelRegistrationEvent
    extends Event
    implements IModBusEvent {
        public void registerModel(ResourceLocation name, IUnbakedModifierModel model) {
            MODIFIER_MODEL_OPTIONS.put(name, model);
        }
    }
}

