/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.data.material;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DirectoryCache;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.Color;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.common.crafting.conditions.NotCondition;
import net.minecraftforge.common.crafting.conditions.OrCondition;
import net.minecraftforge.common.crafting.conditions.TagEmptyCondition;
import slimeknights.tconstruct.common.json.ConfigEnabledCondition;
import slimeknights.tconstruct.library.data.GenericDataProvider;
import slimeknights.tconstruct.library.materials.definition.IMaterial;
import slimeknights.tconstruct.library.materials.definition.Material;
import slimeknights.tconstruct.library.materials.definition.MaterialId;
import slimeknights.tconstruct.library.materials.definition.MaterialManager;
import slimeknights.tconstruct.library.materials.json.MaterialJson;

public abstract class AbstractMaterialDataProvider
extends GenericDataProvider {
    public static final int ORDER_GENERAL = 0;
    public static final int ORDER_HARVEST = 1;
    public static final int ORDER_WEAPON = 2;
    public static final int ORDER_SPECIAL = 3;
    public static final int ORDER_COMPAT = 5;
    public static final int ORDER_NETHER = 10;
    public static final int ORDER_END = 15;
    public static final int ORDER_BINDING = 20;
    private final Map<MaterialId, DataMaterial> allMaterials = new HashMap<MaterialId, DataMaterial>();
    private boolean addMaterialsRun = false;

    public AbstractMaterialDataProvider(DataGenerator gen) {
        super(gen, "materials/definition", MaterialManager.GSON);
    }

    protected abstract void addMaterials();

    private void ensureAddMaterialsRun() {
        if (this.addMaterialsRun) {
            return;
        }
        this.addMaterialsRun = true;
        this.addMaterials();
    }

    public void func_200398_a(DirectoryCache cache) {
        this.ensureAddMaterialsRun();
        this.allMaterials.forEach((id, data) -> this.saveThing(cache, (ResourceLocation)id, this.convert((DataMaterial)data)));
    }

    public Set<MaterialId> getAllMaterials() {
        this.ensureAddMaterialsRun();
        return this.allMaterials.values().stream().map(DataMaterial::getMaterial).filter(Objects::nonNull).map(IMaterial::getIdentifier).collect(Collectors.toSet());
    }

    protected void addMaterial(IMaterial material, @Nullable ICondition condition, MaterialJson.Redirect ... redirect) {
        this.allMaterials.put(material.getIdentifier(), new DataMaterial(material, condition, redirect));
    }

    protected void addRedirect(MaterialId id, @Nullable ICondition condition, MaterialJson.Redirect ... redirect) {
        this.allMaterials.put(id, new DataMaterial(null, condition, redirect));
    }

    protected void addRedirect(MaterialId id, MaterialJson.Redirect ... redirect) {
        this.addRedirect(id, (ICondition)null, redirect);
    }

    protected static ICondition tagExistsCondition(String name) {
        return new NotCondition((ICondition)new TagEmptyCondition("forge", name));
    }

    protected void addMaterial(MaterialId location, int tier, int order, boolean craftable, int color, boolean hidden, @Nullable ICondition condition, MaterialJson.Redirect ... redirect) {
        this.addMaterial(new Material(location, tier, order, craftable, Color.func_240743_a_((int)color), hidden), condition, redirect);
    }

    protected void addMaterial(MaterialId location, int tier, int order, boolean craftable, int color) {
        this.addMaterial(location, tier, order, craftable, color, false, null, new MaterialJson.Redirect[0]);
    }

    protected void addCompatMetalMaterial(MaterialId location, int tier, int order, int color, String ingotName) {
        OrCondition condition = new OrCondition(new ICondition[]{ConfigEnabledCondition.FORCE_INTEGRATION_MATERIALS, AbstractMaterialDataProvider.tagExistsCondition("ingots/" + ingotName)});
        this.addMaterial(location, tier, order, false, color & 0xFFFFFF, false, (ICondition)condition, new MaterialJson.Redirect[0]);
    }

    protected void addCompatMetalMaterial(MaterialId location, int tier, int order, int color) {
        this.addCompatMetalMaterial(location, tier, order, color, location.func_110623_a());
    }

    protected MaterialJson.Redirect conditionalRedirect(MaterialId id, @Nullable ICondition condition) {
        return new MaterialJson.Redirect(id, condition);
    }

    protected MaterialJson.Redirect redirect(MaterialId id) {
        return this.conditionalRedirect(id, null);
    }

    private MaterialJson convert(DataMaterial data) {
        IMaterial material = data.getMaterial();
        MaterialJson.Redirect[] redirect = data.getRedirect();
        if (redirect != null && redirect.length == 0) {
            redirect = null;
        }
        if (material == null) {
            return new MaterialJson(data.getCondition(), null, null, null, null, null, redirect);
        }
        return new MaterialJson(data.getCondition(), material.isCraftable(), material.getTier(), material.getSortOrder(), material.getColor().func_240747_b_(), material.isHidden(), redirect);
    }

    private static class DataMaterial {
        @Nullable
        private final IMaterial material;
        @Nullable
        private final ICondition condition;
        private final MaterialJson.Redirect[] redirect;

        public DataMaterial(@Nullable IMaterial material, @Nullable ICondition condition, MaterialJson.Redirect[] redirect) {
            this.material = material;
            this.condition = condition;
            this.redirect = redirect;
        }

        @Nullable
        public IMaterial getMaterial() {
            return this.material;
        }

        @Nullable
        public ICondition getCondition() {
            return this.condition;
        }

        public MaterialJson.Redirect[] getRedirect() {
            return this.redirect;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof DataMaterial)) {
                return false;
            }
            DataMaterial other = (DataMaterial)o;
            if (!other.canEqual(this)) {
                return false;
            }
            IMaterial this$material = this.getMaterial();
            IMaterial other$material = other.getMaterial();
            if (this$material == null ? other$material != null : !this$material.equals(other$material)) {
                return false;
            }
            ICondition this$condition = this.getCondition();
            ICondition other$condition = other.getCondition();
            if (this$condition == null ? other$condition != null : !this$condition.equals(other$condition)) {
                return false;
            }
            return Arrays.deepEquals(this.getRedirect(), other.getRedirect());
        }

        protected boolean canEqual(Object other) {
            return other instanceof DataMaterial;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            IMaterial $material = this.getMaterial();
            result = result * 59 + ($material == null ? 43 : $material.hashCode());
            ICondition $condition = this.getCondition();
            result = result * 59 + ($condition == null ? 43 : $condition.hashCode());
            result = result * 59 + Arrays.deepHashCode(this.getRedirect());
            return result;
        }

        public String toString() {
            return "AbstractMaterialDataProvider.DataMaterial(material=" + this.getMaterial() + ", condition=" + this.getCondition() + ", redirect=" + Arrays.deepToString(this.getRedirect()) + ")";
        }
    }
}

