/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.data.recipe;

import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.data.IFinishedRecipe;
import net.minecraft.item.Item;
import net.minecraft.tags.ITag;
import slimeknights.tconstruct.common.registration.CastItemObject;
import slimeknights.tconstruct.library.data.recipe.ICastCreationHelper;
import slimeknights.tconstruct.library.recipe.casting.material.CompositeCastingRecipeBuilder;
import slimeknights.tconstruct.library.recipe.casting.material.MaterialCastingRecipeBuilder;
import slimeknights.tconstruct.library.recipe.ingredient.MaterialIngredient;
import slimeknights.tconstruct.library.recipe.partbuilder.PartRecipeBuilder;
import slimeknights.tconstruct.library.recipe.tinkerstation.building.ToolBuildingRecipeBuilder;
import slimeknights.tconstruct.library.tools.item.IModifiable;
import slimeknights.tconstruct.library.tools.part.IMaterialItem;

public interface IToolRecipeHelper
extends ICastCreationHelper {
    default public void toolBuilding(Consumer<IFinishedRecipe> consumer, IModifiable tool, String folder) {
        ToolBuildingRecipeBuilder.toolBuildingRecipe(tool).build(consumer, this.modResource(folder + Objects.requireNonNull(tool.func_199767_j().getRegistryName()).func_110623_a()));
    }

    default public void toolBuilding(Consumer<IFinishedRecipe> consumer, Supplier<? extends IModifiable> tool, String folder) {
        this.toolBuilding(consumer, tool.get(), folder);
    }

    default public void partRecipes(Consumer<IFinishedRecipe> consumer, IMaterialItem part, CastItemObject cast, int cost, String partFolder, String castFolder) {
        String name = Objects.requireNonNull(part.func_199767_j().getRegistryName()).func_110623_a();
        PartRecipeBuilder.partRecipe(part).setPattern(this.modResource(name)).setCost(cost).build(consumer, this.modResource(partFolder + "builder/" + name));
        String castingFolder = partFolder + "casting/";
        MaterialCastingRecipeBuilder.tableRecipe(part).setItemCost(cost).setCast((ITag<Item>)cast.getMultiUseTag(), false).build(consumer, this.modResource(castingFolder + name + "_gold_cast"));
        MaterialCastingRecipeBuilder.tableRecipe(part).setItemCost(cost).setCast((ITag<Item>)cast.getSingleUseTag(), true).build(consumer, this.modResource(castingFolder + name + "_sand_cast"));
        CompositeCastingRecipeBuilder.table(part, cost).build(consumer, this.modResource(castingFolder + name + "_composite"));
        MaterialIngredient ingredient = MaterialIngredient.fromItem(part);
        this.castCreation(consumer, ingredient, cast, castFolder, Objects.requireNonNull(part.func_199767_j().getRegistryName()).func_110623_a());
    }

    default public void partRecipes(Consumer<IFinishedRecipe> consumer, Supplier<? extends IMaterialItem> part, CastItemObject cast, int cost, String partFolder, String castFolder) {
        this.partRecipes(consumer, part.get(), cast, cost, partFolder, castFolder);
    }
}

