/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.data.tinkering;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DirectoryCache;
import net.minecraft.resources.ResourcePackType;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import slimeknights.tconstruct.library.data.GenericDataProvider;
import slimeknights.tconstruct.library.tools.item.IModifiableDisplay;
import slimeknights.tconstruct.library.tools.layout.StationSlotLayout;
import slimeknights.tconstruct.library.tools.layout.StationSlotLayoutLoader;

public abstract class AbstractStationSlotLayoutProvider
extends GenericDataProvider {
    protected static final int SORT_WEAPON = 3;
    protected static final int SORT_HARVEST = 6;
    protected static final int SORT_LARGE = 6;
    private final Map<ResourceLocation, StationSlotLayout.Builder> allLayouts = new HashMap<ResourceLocation, StationSlotLayout.Builder>();

    public AbstractStationSlotLayoutProvider(DataGenerator generator) {
        super(generator, ResourcePackType.SERVER_DATA, "tinkering/station_layouts", StationSlotLayoutLoader.GSON);
    }

    protected abstract void addLayouts();

    protected StationSlotLayout.Builder define(ResourceLocation id) {
        return this.allLayouts.computeIfAbsent(id, i -> StationSlotLayout.builder());
    }

    protected StationSlotLayout.Builder define(IItemProvider item) {
        return this.define(Objects.requireNonNull(item.func_199767_j().getRegistryName()));
    }

    protected StationSlotLayout.Builder defineModifiable(IModifiableDisplay item) {
        return this.define(Objects.requireNonNull(item.func_199767_j().getRegistryName())).translationKey(item.func_199767_j().func_77658_a()).icon(item.getRenderTool());
    }

    protected StationSlotLayout.Builder defineModifiable(Supplier<? extends IModifiableDisplay> item) {
        return this.defineModifiable(item.get());
    }

    public void func_200398_a(DirectoryCache cache) throws IOException {
        this.addLayouts();
        this.allLayouts.forEach((id, builder) -> this.saveThing(cache, (ResourceLocation)id, builder.build()));
    }
}

