/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.data.tinkering;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DirectoryCache;
import net.minecraft.resources.ResourcePackType;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import slimeknights.tconstruct.library.data.GenericDataProvider;
import slimeknights.tconstruct.library.tools.ToolDefinition;
import slimeknights.tconstruct.library.tools.definition.ToolDefinitionData;
import slimeknights.tconstruct.library.tools.definition.ToolDefinitionDataBuilder;
import slimeknights.tconstruct.library.tools.definition.ToolDefinitionLoader;

public abstract class AbstractToolDefinitionDataProvider
extends GenericDataProvider {
    private final Map<ResourceLocation, ToolDefinitionDataBuilder> allTools = new HashMap<ResourceLocation, ToolDefinitionDataBuilder>();
    private final String modId;

    public AbstractToolDefinitionDataProvider(DataGenerator generator, String modId) {
        super(generator, ResourcePackType.SERVER_DATA, "tinkering/tool_definitions", ToolDefinitionLoader.GSON);
        this.modId = modId;
    }

    protected abstract void addToolDefinitions();

    protected ToolDefinitionDataBuilder define(ResourceLocation id) {
        return this.allTools.computeIfAbsent(id, i -> ToolDefinitionDataBuilder.builder());
    }

    protected ToolDefinitionDataBuilder define(IItemProvider item) {
        return this.define(Objects.requireNonNull(item.func_199767_j().getRegistryName()));
    }

    protected ToolDefinitionDataBuilder define(ToolDefinition definition) {
        return this.define(definition.getId());
    }

    public void func_200398_a(DirectoryCache cache) throws IOException {
        this.addToolDefinitions();
        Map relevantDefinitions = ToolDefinitionLoader.getInstance().getRegisteredToolDefinitions().stream().filter(def -> def.getId().func_110624_b().equals(this.modId)).collect(Collectors.toMap(ToolDefinition::getId, Function.identity()));
        for (ToolDefinition toolDefinition : relevantDefinitions.values()) {
            ResourceLocation name = toolDefinition.getId();
            if (this.allTools.containsKey(name)) continue;
            throw new IllegalStateException(String.format("Missing tool definition for '%s'", name));
        }
        for (Map.Entry entry : this.allTools.entrySet()) {
            ResourceLocation id = (ResourceLocation)entry.getKey();
            ToolDefinition definition = (ToolDefinition)relevantDefinitions.get(id);
            if (definition == null) {
                throw new IllegalStateException("Unknown tool definition with ID " + id);
            }
            ToolDefinitionData data = ((ToolDefinitionDataBuilder)entry.getValue()).build();
            definition.validate(data);
            this.saveThing(cache, id, data);
        }
    }
}

