/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.modifiers;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.item.UseAction;
import net.minecraft.loot.LootContext;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.EffectUtils;
import net.minecraft.potion.Effects;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.text.Color;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.logging.log4j.LogManager;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.library.modifiers.ModifierId;
import slimeknights.tconstruct.library.recipe.tinkerstation.ValidatedResult;
import slimeknights.tconstruct.library.tools.ToolDefinition;
import slimeknights.tconstruct.library.tools.context.ToolAttackContext;
import slimeknights.tconstruct.library.tools.context.ToolHarvestContext;
import slimeknights.tconstruct.library.tools.nbt.IModDataReadOnly;
import slimeknights.tconstruct.library.tools.nbt.IModifierToolStack;
import slimeknights.tconstruct.library.tools.nbt.ModDataNBT;
import slimeknights.tconstruct.library.tools.nbt.StatsNBT;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;
import slimeknights.tconstruct.library.tools.stat.FloatToolStat;
import slimeknights.tconstruct.library.tools.stat.ModifierStatsBuilder;
import slimeknights.tconstruct.library.tools.stat.ToolStats;
import slimeknights.tconstruct.library.utils.RestrictedCompoundTag;
import slimeknights.tconstruct.library.utils.RomanNumeralHelper;
import slimeknights.tconstruct.library.utils.TooltipFlag;

public class Modifier
implements IForgeRegistryEntry<Modifier> {
    protected static Random RANDOM = new Random();
    @Deprecated
    protected static final String KEY_LEVEL = "enchantment.level.";
    public static final int DEFAULT_PRIORITY = 100;
    private final int color;
    @Nullable
    private ModifierId registryName;
    @Nullable
    private String translationKey;
    @Nullable
    private ITextComponent displayName;
    @Nullable
    private List<ITextComponent> descriptionList;
    @Nullable
    private ITextComponent description;

    public int getPriority() {
        return 100;
    }

    public final Modifier setRegistryName(ResourceLocation name) {
        if (this.registryName != null) {
            throw new IllegalStateException("Attempted to set registry name with existing registry name! New: " + name + " Old: " + (Object)((Object)this.registryName));
        }
        String activeMod = ModLoadingContext.get().getActiveNamespace();
        if (!name.func_110624_b().equals(activeMod)) {
            LogManager.getLogger().info("Potentially Dangerous alternative prefix for name `{}`, expected `{}`. This could be a intended override, but in most cases indicates a broken mod.", (Object)name, (Object)activeMod);
        }
        this.registryName = new ModifierId(name);
        return this;
    }

    public ModifierId getId() {
        return Objects.requireNonNull(this.registryName, "Modifier has null registry name");
    }

    public Class<Modifier> getRegistryType() {
        return Modifier.class;
    }

    protected String makeTranslationKey() {
        return Util.func_200697_a((String)"modifier", (ResourceLocation)this.registryName);
    }

    public final String getTranslationKey() {
        if (this.translationKey == null) {
            this.translationKey = this.makeTranslationKey();
        }
        return this.translationKey;
    }

    protected ITextComponent makeDisplayName() {
        return new TranslationTextComponent(this.getTranslationKey());
    }

    public IFormattableTextComponent applyStyle(IFormattableTextComponent component) {
        return component.func_240700_a_(style -> style.func_240718_a_(Color.func_240743_a_((int)this.color)));
    }

    public final ITextComponent getDisplayName() {
        if (this.displayName == null) {
            this.displayName = new TranslationTextComponent(this.getTranslationKey()).func_240700_a_(style -> style.func_240718_a_(Color.func_240743_a_((int)this.getColor())));
        }
        return this.displayName;
    }

    public ITextComponent getDisplayName(int level) {
        return this.applyStyle(new TranslationTextComponent(this.getTranslationKey()).func_240702_b_(" ").func_230529_a_(RomanNumeralHelper.getNumeral(level)));
    }

    public ITextComponent getDisplayName(IModifierToolStack tool, int level) {
        return this.getDisplayName(level);
    }

    @Deprecated
    public void addInformation(IModifierToolStack tool, int level, List<ITextComponent> tooltip, boolean isAdvanced, boolean detailed) {
    }

    public void addInformation(IModifierToolStack tool, int level, List<ITextComponent> tooltip, TooltipFlag tooltipFlag) {
        this.addInformation(tool, level, tooltip, tooltipFlag == TooltipFlag.ADVANCED, tooltipFlag == TooltipFlag.DETAILED);
    }

    public List<ITextComponent> getDescriptionList() {
        if (this.descriptionList == null) {
            this.descriptionList = Arrays.asList(new TranslationTextComponent(this.getTranslationKey() + ".flavor").func_240699_a_(TextFormatting.ITALIC), new TranslationTextComponent(this.getTranslationKey() + ".description"));
        }
        return this.descriptionList;
    }

    public List<ITextComponent> getDescriptionList(IModifierToolStack tool, int level) {
        return this.getDescriptionList();
    }

    private static ITextComponent listToComponent(List<ITextComponent> list) {
        if (list.isEmpty()) {
            return StringTextComponent.field_240750_d_;
        }
        StringTextComponent textComponent = new StringTextComponent("");
        Iterator<ITextComponent> iterator = list.iterator();
        textComponent.func_230529_a_(iterator.next());
        while (iterator.hasNext()) {
            textComponent.func_240702_b_("\n");
            textComponent.func_230529_a_(iterator.next());
        }
        return textComponent;
    }

    public final ITextComponent getDescription() {
        if (this.description == null) {
            this.description = Modifier.listToComponent(this.getDescriptionList());
        }
        return this.description;
    }

    public final ITextComponent getDescription(IModifierToolStack tool, int level) {
        List<ITextComponent> extendedDescription = this.getDescriptionList(tool, level);
        if (extendedDescription == this.getDescriptionList()) {
            return this.getDescription();
        }
        return Modifier.listToComponent(extendedDescription);
    }

    @Deprecated
    public void addVolatileData(ToolDefinition toolDefinition, StatsNBT baseStats, IModDataReadOnly persistentData, int level, ModDataNBT volatileData) {
    }

    public void addVolatileData(Item item, ToolDefinition toolDefinition, StatsNBT baseStats, IModDataReadOnly persistentData, int level, ModDataNBT volatileData) {
        this.addVolatileData(toolDefinition, baseStats, persistentData, level, volatileData);
    }

    @Deprecated
    public void addToolStats(ToolDefinition toolDefinition, StatsNBT baseStats, IModDataReadOnly persistentData, IModDataReadOnly volatileData, int level, ModifierStatsBuilder builder) {
    }

    public void addToolStats(Item item, ToolDefinition toolDefinition, StatsNBT baseStats, IModDataReadOnly persistentData, IModDataReadOnly volatileData, int level, ModifierStatsBuilder builder) {
        this.addToolStats(toolDefinition, baseStats, persistentData, volatileData, level, builder);
    }

    public void addAttributes(IModifierToolStack tool, int level, EquipmentSlotType slot, BiConsumer<Attribute, AttributeModifier> consumer) {
    }

    public void addRawData(IModifierToolStack tool, int level, RestrictedCompoundTag tag) {
    }

    public ValidatedResult validate(IModifierToolStack tool, int level) {
        return ValidatedResult.PASS;
    }

    public void beforeRemoved(IModifierToolStack tool, RestrictedCompoundTag tag) {
    }

    public void onRemoved(IModifierToolStack tool) {
    }

    public int onDamageTool(IModifierToolStack toolStack, int level, int amount, @Nullable LivingEntity holder) {
        return this.onDamageTool(toolStack, level, amount);
    }

    @Deprecated
    public int onDamageTool(IModifierToolStack toolStack, int level, int amount) {
        return amount;
    }

    public float getRepairFactor(IModifierToolStack toolStack, int level, float factor) {
        return factor;
    }

    public void onInventoryTick(IModifierToolStack tool, int level, World world, LivingEntity holder, int itemSlot, boolean isSelected, boolean isCorrectSlot, ItemStack stack) {
    }

    public List<ItemStack> processLoot(IModifierToolStack tool, int level, List<ItemStack> generatedLoot, LootContext context) {
        return generatedLoot;
    }

    public ActionResultType beforeBlockUse(IModifierToolStack tool, int level, ItemUseContext context) {
        return ActionResultType.PASS;
    }

    public ActionResultType afterBlockUse(IModifierToolStack tool, int level, ItemUseContext context) {
        return ActionResultType.PASS;
    }

    public ActionResultType onEntityUseFirst(IModifierToolStack tool, int level, PlayerEntity player, Entity target, Hand hand) {
        return ActionResultType.PASS;
    }

    public ActionResultType onEntityUse(IModifierToolStack tool, int level, PlayerEntity player, LivingEntity target, Hand hand) {
        return ActionResultType.PASS;
    }

    public ActionResultType onToolUse(IModifierToolStack tool, int level, World world, PlayerEntity player, Hand hand) {
        return ActionResultType.PASS;
    }

    public boolean onStoppedUsing(IModifierToolStack tool, int level, World world, LivingEntity entity, int timeLeft) {
        return false;
    }

    public boolean onFinishUsing(IModifierToolStack tool, int level, World world, LivingEntity entity) {
        return false;
    }

    public int getUseDuration(IModifierToolStack tool, int level) {
        return 0;
    }

    public UseAction getUseAction(IModifierToolStack tool, int level) {
        return UseAction.NONE;
    }

    public void onBreakSpeed(IModifierToolStack tool, int level, PlayerEvent.BreakSpeed event, Direction sideHit, boolean isEffective, float miningSpeedModifier) {
    }

    public void applyHarvestEnchantments(IModifierToolStack tool, int level, ToolHarvestContext context, BiConsumer<Enchantment, Integer> consumer) {
    }

    public int getLootingValue(IModifierToolStack tool, int level, LivingEntity holder, Entity target, @Nullable DamageSource damageSource, int looting) {
        return looting;
    }

    @Nullable
    public Boolean removeBlock(IModifierToolStack tool, int level, ToolHarvestContext context) {
        return null;
    }

    public void afterBlockBreak(IModifierToolStack tool, int level, ToolHarvestContext context) {
    }

    public void finishBreakingBlocks(IModifierToolStack tool, int level, ToolHarvestContext context) {
    }

    public float getEntityDamage(IModifierToolStack tool, int level, ToolAttackContext context, float baseDamage, float damage) {
        return damage;
    }

    public float beforeEntityHit(IModifierToolStack tool, int level, ToolAttackContext context, float damage, float baseKnockback, float knockback) {
        return knockback;
    }

    public int afterEntityHit(IModifierToolStack tool, int level, ToolAttackContext context, float damageDealt) {
        return 0;
    }

    public void failedEntityHit(IModifierToolStack tool, int level, ToolAttackContext context) {
    }

    public boolean shouldDisplay(boolean advanced) {
        return true;
    }

    public double getDamagePercentage(IModifierToolStack tool, int level) {
        return Double.NaN;
    }

    @Nullable
    public Boolean showDurabilityBar(IModifierToolStack tool, int level) {
        return null;
    }

    public int getDurabilityRGB(IModifierToolStack tool, int level) {
        return -1;
    }

    @Nullable
    public <T> T getModule(Class<T> type) {
        return null;
    }

    public String toString() {
        return "Modifier{" + (Object)((Object)this.registryName) + '}';
    }

    @Nullable
    public static ToolStack getHeldTool(@Nullable LivingEntity living, Hand hand) {
        if (living == null) {
            return null;
        }
        ItemStack stack = living.func_184586_b(hand);
        if (stack.func_190926_b() || !stack.func_77973_b().func_206844_a(TinkerTags.Items.MODIFIABLE)) {
            return null;
        }
        ToolStack tool = ToolStack.from(stack);
        return tool.isBroken() ? null : tool;
    }

    public static float getMiningModifier(LivingEntity entity) {
        EffectInstance miningFatigue;
        float modifier = 1.0f;
        if (EffectUtils.func_205135_a((LivingEntity)entity)) {
            modifier *= 1.0f + (float)(EffectUtils.func_205134_b((LivingEntity)entity) + 1) * 0.2f;
        }
        if ((miningFatigue = entity.func_70660_b(Effects.field_76419_f)) != null) {
            switch (miningFatigue.func_76458_c()) {
                case 0: {
                    modifier *= 0.3f;
                    break;
                }
                case 1: {
                    modifier *= 0.09f;
                    break;
                }
                case 2: {
                    modifier *= 0.0027f;
                    break;
                }
                default: {
                    modifier *= 8.1E-4f;
                }
            }
        }
        if (entity.func_208600_a((ITag)FluidTags.field_206959_a) && !EnchantmentHelper.func_185287_i((LivingEntity)entity)) {
            modifier /= 5.0f;
        }
        if (!entity.func_233570_aj_()) {
            modifier /= 5.0f;
        }
        return modifier;
    }

    protected void addStatTooltip(IModifierToolStack tool, FloatToolStat stat, ITag<Item> condition, float amount, List<ITextComponent> tooltip) {
        if (tool.hasTag(condition)) {
            tooltip.add((ITextComponent)this.applyStyle(new StringTextComponent("+" + slimeknights.tconstruct.library.utils.Util.COMMA_FORMAT.format(amount * tool.getModifier(stat))).func_240702_b_(" ").func_230529_a_((ITextComponent)new TranslationTextComponent(this.getTranslationKey() + "." + stat.getName().func_110623_a()))));
        }
    }

    protected void addDamageTooltip(IModifierToolStack tool, float amount, List<ITextComponent> tooltip) {
        this.addStatTooltip(tool, ToolStats.ATTACK_DAMAGE, (ITag<Item>)TinkerTags.Items.MELEE, amount, tooltip);
    }

    public Modifier(int color) {
        this.color = color;
    }

    public int getColor() {
        return this.color;
    }

    @Nullable
    public ModifierId getRegistryName() {
        return this.registryName;
    }
}

