/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.modifiers;

import java.util.List;
import java.util.function.BiFunction;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.recipe.tinkerstation.ValidatedResult;
import slimeknights.tconstruct.library.tools.ToolDefinition;
import slimeknights.tconstruct.library.tools.capability.ToolFluidCapability;
import slimeknights.tconstruct.library.tools.nbt.IModDataReadOnly;
import slimeknights.tconstruct.library.tools.nbt.IModifierToolStack;
import slimeknights.tconstruct.library.tools.nbt.ModDataNBT;
import slimeknights.tconstruct.library.tools.nbt.StatsNBT;

public class TankModifier
extends Modifier {
    private static final String FILLED_KEY = TConstruct.makeTranslationKey("modifier", "tank.filled");
    private static final String CAPACITY_KEY = TConstruct.makeTranslationKey("modifier", "tank.capacity");
    private static final ResourceLocation OWNER = TConstruct.getResource("tank_owner");
    private static final ResourceLocation CAPACITY = TConstruct.getResource("tank_capacity");
    private static final ResourceLocation FLUID = TConstruct.getResource("tank_fluid");
    public static final BiFunction<CompoundNBT, String, FluidStack> PARSE_FLUID = (nbt, key) -> FluidStack.loadFluidStackFromNBT((CompoundNBT)nbt.func_74775_l(key));
    private final ModifierTank tank = new ModifierTank();
    private final int capacity;

    public TankModifier(int color, int capacity) {
        super(color);
        this.capacity = capacity;
    }

    @Override
    @Nullable
    public <T> T getModule(Class<T> type) {
        if (type == ToolFluidCapability.IFluidModifier.class) {
            return (T)this.tank;
        }
        return super.getModule(type);
    }

    @Override
    public void addVolatileData(ToolDefinition toolDefinition, StatsNBT baseStats, IModDataReadOnly persistentData, int level, ModDataNBT volatileData) {
        ResourceLocation ownerKey = this.getOwnerKey();
        if (ownerKey != null && !volatileData.contains(ownerKey, 8)) {
            volatileData.putString(ownerKey, this.getId().toString());
        }
        ToolFluidCapability.addTanks(volatileData, this.tank);
        if (this.capacity > 0) {
            this.addCapacity(volatileData, this.capacity * level);
        }
    }

    @Override
    public void addInformation(IModifierToolStack tool, int level, List<ITextComponent> tooltip, boolean isAdvanced, boolean detailed) {
        if (this.isOwner(tool)) {
            FluidStack current = this.getFluid(tool);
            if (!current.isEmpty()) {
                tooltip.add((ITextComponent)new TranslationTextComponent(FILLED_KEY, new Object[]{current.getAmount(), current.getDisplayName()}));
            }
            tooltip.add((ITextComponent)new TranslationTextComponent(CAPACITY_KEY, new Object[]{this.getCapacity(tool)}));
        }
    }

    @Override
    public ValidatedResult validate(IModifierToolStack tool, int level) {
        FluidStack fluidStack;
        if (level > 0 && this.isOwner(tool) && !(fluidStack = this.getFluid(tool)).isEmpty()) {
            int capacity = this.getCapacity(tool);
            if (fluidStack.getAmount() > capacity) {
                fluidStack.setAmount(capacity);
                this.setFluid(tool, fluidStack);
            }
        }
        return ValidatedResult.PASS;
    }

    @Override
    public void onRemoved(IModifierToolStack tool) {
        ModDataNBT persistentData = tool.getPersistentData();
        if (!persistentData.contains(OWNER, 8)) {
            persistentData.remove(FLUID);
        }
    }

    @Nullable
    public ResourceLocation getOwnerKey() {
        return OWNER;
    }

    public ResourceLocation getCapacityKey() {
        return CAPACITY;
    }

    public ResourceLocation getFluidKey() {
        return FLUID;
    }

    public boolean isOwner(IModDataReadOnly volatileData) {
        ResourceLocation key = this.getOwnerKey();
        if (key == null) {
            return true;
        }
        return this.getId().toString().equals(volatileData.getString(key));
    }

    public boolean isOwner(IModifierToolStack tool) {
        return this.isOwner(tool.getVolatileData());
    }

    public int getCapacity(IModDataReadOnly volatileData) {
        return volatileData.getInt(CAPACITY);
    }

    public int getCapacity(IModifierToolStack tool) {
        return tool.getVolatileData().getInt(CAPACITY);
    }

    public void addCapacity(ModDataNBT volatileNBT, int amount) {
        if (volatileNBT.contains(CAPACITY, 99)) {
            amount += volatileNBT.getInt(CAPACITY);
        }
        volatileNBT.putInt(CAPACITY, amount);
    }

    public FluidStack getFluid(IModifierToolStack tool) {
        return tool.getPersistentData().get(FLUID, PARSE_FLUID);
    }

    public FluidStack setFluid(IModifierToolStack tool, FluidStack fluid) {
        int capacity = this.getCapacity(tool);
        if (fluid.getAmount() > capacity) {
            fluid.setAmount(capacity);
        }
        tool.getPersistentData().put(FLUID, (INBT)fluid.writeToNBT(new CompoundNBT()));
        return fluid;
    }

    public FluidStack fill(IModifierToolStack tool, FluidStack current, FluidStack resource, int amount) {
        int capacity = this.getCapacity(tool);
        if (current.isEmpty()) {
            resource.setAmount(Math.min(amount, capacity));
            return this.setFluid(tool, resource);
        }
        if (current.isFluidEqual(resource)) {
            current.setAmount(Math.min(current.getAmount() + amount, capacity));
            return this.setFluid(tool, current);
        }
        return FluidStack.EMPTY;
    }

    public FluidStack drain(IModifierToolStack tool, FluidStack current, int amount) {
        if (current.getAmount() < amount) {
            return this.setFluid(tool, FluidStack.EMPTY);
        }
        current.shrink(amount);
        return this.setFluid(tool, current);
    }

    public class ModifierTank
    implements ToolFluidCapability.IFluidModifier {
        @Override
        public int getTanks(IModDataReadOnly volatileData) {
            return TankModifier.this.isOwner(volatileData) ? 1 : 0;
        }

        @Override
        public FluidStack getFluidInTank(IModifierToolStack tool, int level, int tank) {
            return TankModifier.this.isOwner(tool) ? TankModifier.this.getFluid(tool) : FluidStack.EMPTY;
        }

        @Override
        public int getTankCapacity(IModifierToolStack tool, int level, int tank) {
            return TankModifier.this.isOwner(tool) ? TankModifier.this.getCapacity(tool) : 0;
        }

        @Override
        public int fill(IModifierToolStack tool, int level, FluidStack resource, IFluidHandler.FluidAction action) {
            if (!resource.isEmpty() && TankModifier.this.isOwner(tool)) {
                FluidStack current = TankModifier.this.getFluid(tool);
                int remaining = TankModifier.this.getCapacity(tool) - current.getAmount();
                if (remaining <= 0) {
                    return 0;
                }
                if (!current.isEmpty() && !current.isFluidEqual(resource)) {
                    return 0;
                }
                int filled = Math.min(remaining, resource.getAmount());
                if (filled > 0 && action.execute()) {
                    TankModifier.this.fill(tool, current, resource, filled);
                }
                return filled;
            }
            return 0;
        }

        @Override
        public FluidStack drain(IModifierToolStack tool, int level, FluidStack resource, IFluidHandler.FluidAction action) {
            if (!resource.isEmpty() && TankModifier.this.isOwner(tool)) {
                FluidStack current = TankModifier.this.getFluid(tool);
                if (current.isEmpty() || !current.isFluidEqual(resource)) {
                    return FluidStack.EMPTY;
                }
                int drainedAmount = Math.min(current.getAmount(), resource.getAmount());
                FluidStack drained = new FluidStack(current, drainedAmount);
                if (action.execute()) {
                    TankModifier.this.drain(tool, current, drainedAmount);
                }
                return drained;
            }
            return FluidStack.EMPTY;
        }

        @Override
        public FluidStack drain(IModifierToolStack tool, int level, int maxDrain, IFluidHandler.FluidAction action) {
            if (maxDrain > 0 && TankModifier.this.isOwner(tool)) {
                FluidStack current = TankModifier.this.getFluid(tool);
                if (current.isEmpty()) {
                    return FluidStack.EMPTY;
                }
                int drainedAmount = Math.min(current.getAmount(), maxDrain);
                FluidStack drained = new FluidStack(current, drainedAmount);
                if (action.execute()) {
                    TankModifier.this.drain(tool, current, drainedAmount);
                }
                return drained;
            }
            return FluidStack.EMPTY;
        }
    }
}

