/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.recipe.alloying;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.BitSet;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import slimeknights.mantle.recipe.FluidIngredient;
import slimeknights.mantle.recipe.ICustomOutputRecipe;
import slimeknights.mantle.recipe.RecipeHelper;
import slimeknights.mantle.util.JsonHelper;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.common.recipe.LoggingRecipeSerializer;
import slimeknights.tconstruct.library.recipe.RecipeTypes;
import slimeknights.tconstruct.library.recipe.alloying.IAlloyTank;
import slimeknights.tconstruct.library.recipe.alloying.IMutableAlloyTank;
import slimeknights.tconstruct.smeltery.TinkerSmeltery;

public class AlloyRecipe
implements ICustomOutputRecipe<IAlloyTank> {
    private final ResourceLocation id;
    private final List<FluidIngredient> inputs;
    private final FluidStack output;
    private final int temperature;
    private List<List<FluidStack>> displayInputs;

    public List<List<FluidStack>> getDisplayInputs() {
        if (this.displayInputs == null) {
            this.displayInputs = this.inputs.stream().map(FluidIngredient::getFluids).collect(Collectors.toList());
        }
        return this.displayInputs;
    }

    private static BitSet makeBitset(IAlloyTank inv) {
        int tanks = inv.getTanks();
        BitSet used = new BitSet(tanks);
        for (int i = 0; i < tanks; ++i) {
            if (!inv.getFluidInTank(i).isEmpty()) continue;
            used.set(i);
        }
        return used;
    }

    private static int findMatch(FluidIngredient ingredient, IAlloyTank inv, BitSet used, boolean checkSize) {
        for (int i = 0; i < inv.getTanks(); ++i) {
            if (used.get(i)) continue;
            FluidStack fluid = inv.getFluidInTank(i);
            if (!(checkSize ? ingredient.test(fluid) : ingredient.test(fluid.getFluid()))) continue;
            used.set(i);
            return i;
        }
        return -1;
    }

    public boolean matches(IAlloyTank inv, World worldIn) {
        BitSet used = AlloyRecipe.makeBitset(inv);
        for (FluidIngredient ingredient : this.inputs) {
            int index = AlloyRecipe.findMatch(ingredient, inv, used, false);
            if (index != -1) continue;
            return false;
        }
        return true;
    }

    public boolean canPerform(IAlloyTank inv) {
        if (inv.getTemperature() < this.temperature) {
            return false;
        }
        BitSet used = AlloyRecipe.makeBitset(inv);
        int drainAmount = 0;
        for (FluidIngredient ingredient : this.inputs) {
            int index = AlloyRecipe.findMatch(ingredient, inv, used, true);
            if (index != -1) {
                FluidStack fluid = inv.getFluidInTank(index);
                drainAmount += ingredient.getAmount(fluid.getFluid());
                continue;
            }
            return false;
        }
        return inv.canFit(this.output, drainAmount);
    }

    public void performRecipe(IMutableAlloyTank inv) {
        if (inv.getTemperature() < this.temperature) {
            return;
        }
        FluidStack[] drainFluids = new FluidStack[inv.getTanks()];
        int drainAmount = 0;
        BitSet used = AlloyRecipe.makeBitset(inv);
        for (FluidIngredient ingredient : this.inputs) {
            int index = AlloyRecipe.findMatch(ingredient, inv, used, true);
            if (index != -1 && drainFluids[index] == null) {
                FluidStack fluid = inv.getFluidInTank(index);
                int amount = ingredient.getAmount(fluid.getFluid());
                drainAmount += amount;
                drainFluids[index] = new FluidStack(fluid, amount);
                continue;
            }
            return;
        }
        if (inv.canFit(this.output, drainAmount)) {
            for (int i = 0; i < drainFluids.length; ++i) {
                FluidStack drained;
                FluidStack toDrain = drainFluids[i];
                if (toDrain == null || (drained = inv.drain(i, toDrain)).getAmount() == toDrain.getAmount()) continue;
                TConstruct.LOG.error("Wrong amount of fluid {} drained for recipe {}", (Object)drained.getFluid(), (Object)this.id);
            }
            int filled = inv.fill(this.output.copy());
            if (filled != this.output.getAmount()) {
                TConstruct.LOG.error("Filled only {} for recipe {}", (Object)filled, (Object)this.id);
            }
        }
    }

    public IRecipeType<?> func_222127_g() {
        return RecipeTypes.ALLOYING;
    }

    public IRecipeSerializer<?> func_199559_b() {
        return (IRecipeSerializer)TinkerSmeltery.alloyingSerializer.get();
    }

    public AlloyRecipe(ResourceLocation id, List<FluidIngredient> inputs, FluidStack output, int temperature) {
        this.id = id;
        this.inputs = inputs;
        this.output = output;
        this.temperature = temperature;
    }

    public ResourceLocation func_199560_c() {
        return this.id;
    }

    public FluidStack getOutput() {
        return this.output;
    }

    public int getTemperature() {
        return this.temperature;
    }

    public static class Serializer
    extends LoggingRecipeSerializer<AlloyRecipe> {
        public AlloyRecipe read(ResourceLocation id, JsonObject json) {
            FluidStack result = RecipeHelper.deserializeFluidStack((JsonObject)JSONUtils.func_152754_s((JsonObject)json, (String)"result"));
            List inputs = JsonHelper.parseList((JsonObject)json, (String)"inputs", FluidIngredient::deserialize);
            if (inputs.size() < 2) {
                throw new JsonSyntaxException("Too few inputs to alloy recipe " + id);
            }
            for (FluidIngredient input : inputs) {
                if (!input.test(result)) continue;
                throw new JsonSyntaxException("Result fluid contained in input in alloy recipe " + id);
            }
            int temperature = JSONUtils.func_151203_m((JsonObject)json, (String)"temperature");
            return new AlloyRecipe(id, inputs, result, temperature);
        }

        @Override
        protected void writeSafe(PacketBuffer buffer, AlloyRecipe recipe) {
            buffer.writeFluidStack(recipe.output);
            buffer.func_150787_b(recipe.inputs.size());
            for (FluidIngredient input : recipe.inputs) {
                input.write(buffer);
            }
            buffer.func_150787_b(recipe.temperature);
        }

        @Override
        @Nullable
        protected AlloyRecipe readSafe(ResourceLocation id, PacketBuffer buffer) {
            FluidStack output = buffer.readFluidStack();
            int inputCount = buffer.func_150792_a();
            ImmutableList.Builder builder = ImmutableList.builder();
            for (int i = 0; i < inputCount; ++i) {
                builder.add((Object)FluidIngredient.read((PacketBuffer)buffer));
            }
            int temperature = buffer.func_150792_a();
            return new AlloyRecipe(id, (List<FluidIngredient>)builder.build(), output, temperature);
        }
    }
}

