/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.recipe.alloying;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.data.IFinishedRecipe;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.tags.ITag;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;
import slimeknights.mantle.recipe.FluidIngredient;
import slimeknights.mantle.recipe.RecipeHelper;
import slimeknights.mantle.recipe.data.AbstractRecipeBuilder;
import slimeknights.tconstruct.smeltery.TinkerSmeltery;

public class AlloyRecipeBuilder
extends AbstractRecipeBuilder<AlloyRecipeBuilder> {
    private final FluidStack output;
    private final int temperature;
    private final List<FluidIngredient> inputs = new ArrayList<FluidIngredient>();

    public static AlloyRecipeBuilder alloy(FluidStack fluid) {
        return AlloyRecipeBuilder.alloy(fluid, fluid.getFluid().getAttributes().getTemperature(fluid) - 300);
    }

    public static AlloyRecipeBuilder alloy(Fluid fluid, int amount) {
        return AlloyRecipeBuilder.alloy(new FluidStack(fluid, amount));
    }

    public AlloyRecipeBuilder addInput(FluidIngredient input) {
        this.inputs.add(input);
        return this;
    }

    public AlloyRecipeBuilder addInput(FluidStack input) {
        return this.addInput(FluidIngredient.of((FluidStack)input));
    }

    public AlloyRecipeBuilder addInput(Fluid fluid, int amount) {
        return this.addInput(FluidIngredient.of((FluidStack)new FluidStack(fluid, amount)));
    }

    public AlloyRecipeBuilder addInput(ITag<Fluid> tag, int amount) {
        return this.addInput(FluidIngredient.of(tag, (int)amount));
    }

    public void build(Consumer<IFinishedRecipe> consumer) {
        this.build(consumer, Objects.requireNonNull(this.output.getFluid().getRegistryName()));
    }

    public void build(Consumer<IFinishedRecipe> consumer, ResourceLocation id) {
        if (this.inputs.size() < 2) {
            throw new IllegalStateException("Invalid alloying recipe " + id + ", must have at least two inputs");
        }
        ResourceLocation advancementId = this.buildOptionalAdvancement(id, "alloys");
        consumer.accept((IFinishedRecipe)new Result(id, advancementId));
    }

    private AlloyRecipeBuilder(FluidStack output, int temperature) {
        this.output = output;
        this.temperature = temperature;
    }

    public static AlloyRecipeBuilder alloy(FluidStack output, int temperature) {
        return new AlloyRecipeBuilder(output, temperature);
    }

    private class Result
    extends AbstractRecipeBuilder.AbstractFinishedRecipe {
        public Result(@Nullable ResourceLocation ID, ResourceLocation advancementID) {
            super((AbstractRecipeBuilder)AlloyRecipeBuilder.this, ID, advancementID);
        }

        public void func_218610_a(JsonObject json) {
            JsonArray inputArray = new JsonArray();
            for (FluidIngredient input : AlloyRecipeBuilder.this.inputs) {
                inputArray.add(input.serialize());
            }
            json.add("inputs", (JsonElement)inputArray);
            json.add("result", (JsonElement)RecipeHelper.serializeFluidStack((FluidStack)AlloyRecipeBuilder.this.output));
            json.addProperty("temperature", (Number)AlloyRecipeBuilder.this.temperature);
        }

        public IRecipeSerializer<?> func_218609_c() {
            return (IRecipeSerializer)TinkerSmeltery.alloyingSerializer.get();
        }
    }
}

