/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.recipe.material;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.LazyValue;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.items.ItemHandlerHelper;
import slimeknights.mantle.recipe.ICustomOutputRecipe;
import slimeknights.mantle.recipe.ItemOutput;
import slimeknights.mantle.recipe.inventory.ISingleItemInventory;
import slimeknights.tconstruct.library.materials.MaterialRegistry;
import slimeknights.tconstruct.library.materials.definition.IMaterial;
import slimeknights.tconstruct.library.materials.definition.MaterialId;
import slimeknights.tconstruct.library.materials.stats.IRepairableMaterialStats;
import slimeknights.tconstruct.library.materials.stats.MaterialStatsId;
import slimeknights.tconstruct.library.recipe.RecipeTypes;
import slimeknights.tconstruct.tables.TinkerTables;

public class MaterialRecipe
implements ICustomOutputRecipe<ISingleItemInventory> {
    public static final float INGOTS_PER_REPAIR = 3.0f;
    protected final ResourceLocation id;
    protected final String group;
    protected final Ingredient ingredient;
    protected final int value;
    protected final int needed;
    protected final MaterialId materialId;
    protected final ItemOutput leftover;
    private final LazyValue<IMaterial> material;
    @Nullable
    private Float repairPerItem;
    private List<ItemStack> displayItems = null;

    public MaterialRecipe(ResourceLocation id, String group, Ingredient ingredient, int value, int needed, MaterialId materialId, ItemOutput leftover) {
        this.id = id;
        this.group = group;
        this.ingredient = ingredient;
        this.value = value;
        this.needed = needed;
        this.materialId = materialId;
        this.material = new LazyValue(() -> MaterialRegistry.getMaterial(materialId));
        this.leftover = leftover;
    }

    public IRecipeType<?> func_222127_g() {
        return RecipeTypes.MATERIAL;
    }

    public ItemStack func_222128_h() {
        return new ItemStack(TinkerTables.partBuilder);
    }

    public IRecipeSerializer<?> func_199559_b() {
        return (IRecipeSerializer)TinkerTables.materialRecipeSerializer.get();
    }

    public boolean matches(ISingleItemInventory inv, World worldIn) {
        return this.getMaterial() != IMaterial.UNKNOWN && this.ingredient.test(inv.getStack());
    }

    public NonNullList<Ingredient> func_192400_c() {
        return NonNullList.func_193580_a((Object)Ingredient.field_193370_a, (Object[])new Ingredient[]{this.ingredient});
    }

    public List<ItemStack> getDisplayItems() {
        if (this.displayItems == null) {
            this.displayItems = this.needed > 1 ? Arrays.stream(this.ingredient.func_193365_a()).map(stack -> ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)this.needed)).collect(Collectors.toList()) : Arrays.asList(this.ingredient.func_193365_a());
        }
        return this.displayItems;
    }

    public IMaterial getMaterial() {
        return (IMaterial)this.material.func_179281_c();
    }

    public float getMaterialValue(ISingleItemInventory inv) {
        return (float)(inv.getStack().func_190916_E() * this.value) / (float)this.needed;
    }

    public int getItemsUsed(int itemCost) {
        int needed = itemCost * this.needed;
        int cost = needed / this.value;
        if (needed % this.value != 0) {
            ++cost;
        }
        return cost;
    }

    public int getRemainder(int itemCost) {
        return itemCost * this.needed % this.value;
    }

    public float getRepairPerItem(MaterialStatsId statsId) {
        if (this.repairPerItem == null) {
            this.repairPerItem = Float.valueOf((float)(this.getValue() * MaterialRecipe.getRepairDurability(this.materialId, statsId)) / 3.0f / (float)this.getNeeded());
        }
        return this.repairPerItem.floatValue();
    }

    public static int getRepairDurability(MaterialId materialId, MaterialStatsId statsId) {
        return MaterialRegistry.getInstance().getMaterialStats(materialId, statsId).filter(stats -> stats instanceof IRepairableMaterialStats).map(stats -> ((IRepairableMaterialStats)stats).getDurability()).orElse(0);
    }

    public ItemStack getLeftover() {
        return this.leftover.get().func_77946_l();
    }

    public ResourceLocation func_199560_c() {
        return this.id;
    }

    public String func_193358_e() {
        return this.group;
    }

    public int getValue() {
        return this.value;
    }

    public int getNeeded() {
        return this.needed;
    }

    public MaterialId getMaterialId() {
        return this.materialId;
    }
}

