/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.recipe.modifiers.salvage;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.Random;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.registries.IForgeRegistryEntry;
import slimeknights.mantle.recipe.ICustomOutputRecipe;
import slimeknights.mantle.util.JsonHelper;
import slimeknights.tconstruct.common.recipe.LoggingRecipeSerializer;
import slimeknights.tconstruct.library.TinkerRegistries;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.recipe.RecipeTypes;
import slimeknights.tconstruct.library.tools.SlotType;
import slimeknights.tconstruct.library.tools.nbt.IModifierToolStack;
import slimeknights.tconstruct.library.utils.JsonUtils;

public abstract class AbstractModifierSalvage
implements ICustomOutputRecipe<IInventory> {
    protected final ResourceLocation id;
    protected final Ingredient toolIngredient;
    protected final Modifier modifier;
    protected final int minLevel;
    protected final int maxLevel;
    @Nullable
    protected final SlotType.SlotCount slots;

    public boolean matches(ItemStack stack, IModifierToolStack tool, int originalLevel) {
        return originalLevel >= this.minLevel && originalLevel <= this.maxLevel && this.toolIngredient.test(stack);
    }

    public void updateTool(IModifierToolStack tool) {
        if (this.slots != null) {
            tool.getPersistentData().addSlots(this.slots.getType(), this.slots.getCount());
        }
    }

    public abstract void acceptItems(IModifierToolStack var1, Consumer<ItemStack> var2, Random var3);

    public IRecipeType<?> func_222127_g() {
        return RecipeTypes.DATA;
    }

    @Deprecated
    public boolean func_77569_a(IInventory inv, World worldIn) {
        return false;
    }

    public AbstractModifierSalvage(ResourceLocation id, Ingredient toolIngredient, Modifier modifier, int minLevel, int maxLevel, @Nullable SlotType.SlotCount slots) {
        this.id = id;
        this.toolIngredient = toolIngredient;
        this.modifier = modifier;
        this.minLevel = minLevel;
        this.maxLevel = maxLevel;
        this.slots = slots;
    }

    public ResourceLocation func_199560_c() {
        return this.id;
    }

    public Modifier getModifier() {
        return this.modifier;
    }

    public static abstract class AbstractSerializer<T extends AbstractModifierSalvage>
    extends LoggingRecipeSerializer<T> {
        protected abstract T read(ResourceLocation var1, JsonObject var2, Ingredient var3, Modifier var4, int var5, int var6, @Nullable SlotType.SlotCount var7);

        protected abstract T read(ResourceLocation var1, PacketBuffer var2, Ingredient var3, Modifier var4, int var5, int var6, @Nullable SlotType.SlotCount var7);

        public T read(ResourceLocation id, JsonObject json) {
            Ingredient toolIngredient = Ingredient.func_199802_a((JsonElement)JsonHelper.getElement((JsonObject)json, (String)"tools"));
            Modifier modifier = ModifierEntry.deserializeModifier(json, "modifier");
            int minLevel = JsonUtils.getIntMin(json, "min_level", 1);
            int maxLevel = JSONUtils.func_151208_a((JsonObject)json, (String)"max_level", (int)Integer.MAX_VALUE);
            if (maxLevel < minLevel) {
                throw new JsonSyntaxException("Max level must be greater than or equal to min level");
            }
            SlotType.SlotCount slots = null;
            if (json.has("slots")) {
                slots = SlotType.SlotCount.fromJson(JSONUtils.func_152754_s((JsonObject)json, (String)"slots"));
            }
            return this.read(id, json, toolIngredient, modifier, minLevel, maxLevel, slots);
        }

        @Override
        @Nullable
        protected T readSafe(ResourceLocation id, PacketBuffer buffer) {
            Ingredient toolIngredient = Ingredient.func_199566_b((PacketBuffer)buffer);
            Modifier modifier = (Modifier)buffer.readRegistryIdUnsafe(TinkerRegistries.MODIFIERS);
            int minLevel = buffer.func_150792_a();
            int maxLevel = buffer.func_150792_a();
            SlotType.SlotCount slots = SlotType.SlotCount.read(buffer);
            return this.read(id, buffer, toolIngredient, modifier, minLevel, maxLevel, slots);
        }

        @Override
        protected void writeSafe(PacketBuffer buffer, T recipe) {
            ((AbstractModifierSalvage)recipe).toolIngredient.func_199564_a(buffer);
            buffer.writeRegistryIdUnsafe(TinkerRegistries.MODIFIERS, (IForgeRegistryEntry)((AbstractModifierSalvage)recipe).modifier);
            buffer.func_150787_b(((AbstractModifierSalvage)recipe).minLevel);
            buffer.func_150787_b(((AbstractModifierSalvage)recipe).maxLevel);
            SlotType.SlotCount.write(((AbstractModifierSalvage)recipe).slots, buffer);
        }
    }
}

