/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.recipe.modifiers.salvage;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Random;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.items.ItemHandlerHelper;
import slimeknights.mantle.recipe.ItemOutput;
import slimeknights.mantle.util.JsonHelper;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierId;
import slimeknights.tconstruct.library.recipe.modifiers.ModifierRecipeLookup;
import slimeknights.tconstruct.library.recipe.modifiers.salvage.AbstractModifierSalvage;
import slimeknights.tconstruct.library.tools.SlotType;
import slimeknights.tconstruct.library.tools.nbt.IModifierToolStack;
import slimeknights.tconstruct.tools.TinkerModifiers;

public class IncrementalModifierSalvage
extends AbstractModifierSalvage {
    private final ItemOutput result;
    private final boolean fullSalvage;

    public IncrementalModifierSalvage(ResourceLocation id, Ingredient toolIngredient, Modifier modifier, int minLevel, int maxLevel, ItemOutput result, boolean fullSalvage, @Nullable SlotType.SlotCount slots) {
        super(id, toolIngredient, modifier, minLevel, maxLevel, slots);
        this.result = result;
        this.fullSalvage = fullSalvage;
        ModifierRecipeLookup.addSalvage(this);
    }

    @Override
    public void updateTool(IModifierToolStack tool) {
        super.updateTool(tool);
        tool.getPersistentData().remove(this.getModifier().getId());
    }

    @Override
    public void acceptItems(IModifierToolStack tool, Consumer<ItemStack> stackConsumer, Random random) {
        ModifierId key = this.getModifier().getId();
        int maxValue = tool.getPersistentData().contains(key, 99) ? tool.getPersistentData().getInt(this.getModifier().getId()) : ModifierRecipeLookup.getNeededPerLevel(this.getModifier());
        if (maxValue > 0) {
            int amount;
            int n = amount = this.fullSalvage ? maxValue : random.nextInt(maxValue);
            if (amount > 0) {
                ItemStack result = this.result.get();
                stackConsumer.accept(ItemHandlerHelper.copyStackWithSize((ItemStack)result, (int)(amount * result.func_190916_E())));
            }
        }
    }

    public IRecipeSerializer<?> func_199559_b() {
        return (IRecipeSerializer)TinkerModifiers.incrementalModifierSalvageSerializer.get();
    }

    public static class Serializer
    extends AbstractModifierSalvage.AbstractSerializer<IncrementalModifierSalvage> {
        @Override
        protected IncrementalModifierSalvage read(ResourceLocation id, JsonObject json, Ingredient toolIngredient, Modifier modifier, int minLevel, int maxLevel, @Nullable SlotType.SlotCount slots) {
            JsonElement salvageElement = JsonHelper.getElement((JsonObject)json, (String)"salvage");
            ItemOutput result = ItemOutput.fromJson((JsonElement)salvageElement);
            boolean fullSalvage = false;
            if (salvageElement.isJsonObject()) {
                fullSalvage = JSONUtils.func_151209_a((JsonObject)salvageElement.getAsJsonObject(), (String)"full", (boolean)false);
            }
            return new IncrementalModifierSalvage(id, toolIngredient, modifier, minLevel, maxLevel, result, fullSalvage, slots);
        }

        @Override
        protected IncrementalModifierSalvage read(ResourceLocation id, PacketBuffer buffer, Ingredient toolIngredient, Modifier modifier, int minLevel, int maxLevel, @Nullable SlotType.SlotCount slots) {
            ItemOutput result = ItemOutput.read((PacketBuffer)buffer);
            boolean fullSalvage = buffer.readBoolean();
            return new IncrementalModifierSalvage(id, toolIngredient, modifier, minLevel, maxLevel, result, fullSalvage, slots);
        }

        @Override
        protected void writeSafe(PacketBuffer buffer, IncrementalModifierSalvage recipe) {
            super.writeSafe(buffer, recipe);
            recipe.result.write(buffer);
            buffer.writeBoolean(recipe.fullSalvage);
        }
    }
}

