/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.tools.definition;

import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.JsonSyntaxException;
import io.netty.handler.codec.DecoderException;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import slimeknights.tconstruct.library.tools.stat.FloatToolStat;
import slimeknights.tconstruct.library.tools.stat.IToolStat;
import slimeknights.tconstruct.library.tools.stat.ToolStatId;
import slimeknights.tconstruct.library.tools.stat.ToolStats;

public class DefinitionToolStats {
    protected static final DefinitionToolStats EMPTY = new DefinitionToolStats(Collections.emptyMap());
    public static Serializer SERIALIZER = new Serializer();
    private final Map<FloatToolStat, Float> values;

    public float getStat(FloatToolStat stat, float defaultValue) {
        return this.values.getOrDefault(stat, Float.valueOf(defaultValue)).floatValue();
    }

    public Set<FloatToolStat> containedStats() {
        return this.values.keySet();
    }

    public static Builder builder() {
        return new Builder();
    }

    public void write(PacketBuffer buffer) {
        buffer.func_150787_b(this.values.size());
        for (Map.Entry<FloatToolStat, Float> entry : this.values.entrySet()) {
            buffer.func_180714_a(entry.getKey().getName().toString());
            buffer.writeFloat(entry.getValue().floatValue());
        }
    }

    public static DefinitionToolStats read(PacketBuffer buffer) {
        Builder builder = DefinitionToolStats.builder();
        int max = buffer.func_150792_a();
        for (int i = 0; i < max; ++i) {
            ToolStatId id = new ToolStatId(buffer.func_150789_c(Short.MAX_VALUE));
            IToolStat<?> stat = ToolStats.getToolStat(id);
            if (!(stat instanceof FloatToolStat)) {
                throw new DecoderException("Invalid stat type name " + (Object)((Object)id));
            }
            builder.addStat((FloatToolStat)stat, buffer.readFloat());
        }
        return builder.build();
    }

    protected DefinitionToolStats(Map<FloatToolStat, Float> values) {
        this.values = values;
    }

    protected static class Serializer
    implements JsonDeserializer<DefinitionToolStats>,
    JsonSerializer<DefinitionToolStats> {
        protected Serializer() {
        }

        public DefinitionToolStats deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonObject object = JSONUtils.func_151210_l((JsonElement)json, (String)"stats");
            Builder builder = DefinitionToolStats.builder();
            for (Map.Entry entry : object.entrySet()) {
                IToolStat<?> stat;
                ResourceLocation location = ResourceLocation.func_208304_a((String)((String)entry.getKey()));
                if (location != null && (stat = ToolStats.getToolStat(new ToolStatId(location))) instanceof FloatToolStat) {
                    builder.addStat((FloatToolStat)stat, JSONUtils.func_151220_d((JsonElement)((JsonElement)entry.getValue()), (String)((String)entry.getKey())));
                    continue;
                }
                throw new JsonSyntaxException("Unknown stat type " + (String)entry.getKey());
            }
            return builder.build();
        }

        public JsonElement serialize(DefinitionToolStats stats, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject json = new JsonObject();
            for (Map.Entry entry : stats.values.entrySet()) {
                json.addProperty(((FloatToolStat)entry.getKey()).getName().toString(), (Number)entry.getValue());
            }
            return json;
        }
    }

    public static class Builder {
        private final ImmutableMap.Builder<FloatToolStat, Float> builder = ImmutableMap.builder();

        protected Builder() {
        }

        public Builder addStat(FloatToolStat stat, float value) {
            this.builder.put((Object)stat, (Object)Float.valueOf(value));
            return this;
        }

        public DefinitionToolStats build() {
            return new DefinitionToolStats((Map<FloatToolStat, Float>)this.builder.build());
        }
    }
}

