/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.tools.definition;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.JsonSyntaxException;
import java.lang.reflect.Type;
import java.util.Objects;
import net.minecraft.item.Item;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;
import slimeknights.mantle.recipe.RecipeHelper;
import slimeknights.mantle.util.JsonHelper;
import slimeknights.tconstruct.library.materials.stats.MaterialStatsId;
import slimeknights.tconstruct.library.tools.part.IToolPart;

public class PartRequirement {
    public static final Serializer SERIALIZER = new Serializer();
    private final IToolPart part;
    private final int weight;

    public void write(PacketBuffer buffer) {
        RecipeHelper.writeItem((PacketBuffer)buffer, (IItemProvider)this.part);
        buffer.func_150787_b(this.weight);
    }

    public static PartRequirement read(PacketBuffer buffer) {
        IToolPart part = (IToolPart)RecipeHelper.readItem((PacketBuffer)buffer, IToolPart.class);
        int weight = buffer.func_150792_a();
        return new PartRequirement(part, weight);
    }

    public MaterialStatsId getStatType() {
        return this.part.getStatType();
    }

    public PartRequirement(IToolPart part, int weight) {
        this.part = part;
        this.weight = weight;
    }

    public IToolPart getPart() {
        return this.part;
    }

    public int getWeight() {
        return this.weight;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PartRequirement)) {
            return false;
        }
        PartRequirement other = (PartRequirement)o;
        if (!other.canEqual(this)) {
            return false;
        }
        IToolPart this$part = this.getPart();
        IToolPart other$part = other.getPart();
        if (this$part == null ? other$part != null : !this$part.equals(other$part)) {
            return false;
        }
        return this.getWeight() == other.getWeight();
    }

    protected boolean canEqual(Object other) {
        return other instanceof PartRequirement;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        IToolPart $part = this.getPart();
        result = result * 59 + ($part == null ? 43 : $part.hashCode());
        result = result * 59 + this.getWeight();
        return result;
    }

    public String toString() {
        return "PartRequirement(part=" + this.getPart() + ", weight=" + this.getWeight() + ")";
    }

    protected static class Serializer
    implements JsonDeserializer<PartRequirement>,
    JsonSerializer<PartRequirement> {
        protected Serializer() {
        }

        public PartRequirement deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonObject jsonObject = JSONUtils.func_151210_l((JsonElement)json, (String)"part");
            ResourceLocation name = JsonHelper.getResourceLocation((JsonObject)jsonObject, (String)"item");
            if (!ForgeRegistries.ITEMS.containsKey(name)) {
                throw new JsonSyntaxException("Invalid item '" + name + "' for tool part, does not exist");
            }
            Item item = (Item)Objects.requireNonNull(ForgeRegistries.ITEMS.getValue(name));
            if (!(item instanceof IToolPart)) {
                throw new JsonSyntaxException("Invalid item '" + name + "' for tool part, must implement IToolPart");
            }
            int weight = JSONUtils.func_151208_a((JsonObject)jsonObject, (String)"weight", (int)1);
            return new PartRequirement((IToolPart)item, weight);
        }

        public JsonElement serialize(PartRequirement part, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject jsonObject = new JsonObject();
            jsonObject.addProperty("item", Objects.requireNonNull(part.part.func_199767_j().getRegistryName()).toString());
            if (part.weight != 1) {
                jsonObject.addProperty("weight", (Number)part.weight);
            }
            return jsonObject;
        }
    }
}

