/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.tools.helper;

import java.util.HashMap;
import java.util.Random;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.tools.context.ToolHarvestContext;
import slimeknights.tconstruct.library.tools.nbt.IModifierToolStack;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;

public final class ModifierUtil {
    public static final String TAG_ENCHANTMENTS = "Enchantments";
    public static final String TAG_HIDE_FLAGS = "HideFlags";

    public static boolean applyHarvestEnchants(ToolStack tool, ItemStack stack, ToolHarvestContext context) {
        boolean addedEnchants = false;
        ServerPlayerEntity player = context.getPlayer();
        if (player == null || !player.func_184812_l_()) {
            HashMap enchantments = new HashMap();
            BiConsumer<Enchantment, Integer> enchantmentConsumer = (ench, add) -> {
                if (ench != null && add != null) {
                    Integer level = (Integer)enchantments.get(ench);
                    if (level != null) {
                        add = add + level;
                    }
                    enchantments.put(ench, add);
                }
            };
            for (ModifierEntry entry : tool.getModifierList()) {
                entry.getModifier().applyHarvestEnchantments(tool, entry.getLevel(), context, enchantmentConsumer);
            }
            if (!enchantments.isEmpty()) {
                addedEnchants = true;
                EnchantmentHelper.func_82782_a(enchantments, (ItemStack)stack);
                stack.func_196082_o().func_74768_a(TAG_HIDE_FLAGS, ItemStack.TooltipDisplayFlags.ENCHANTMENTS.func_242397_a());
            }
        }
        return addedEnchants;
    }

    public static void clearEnchantments(ItemStack stack) {
        CompoundNBT nbt = stack.func_77978_p();
        if (nbt != null) {
            nbt.func_82580_o(TAG_ENCHANTMENTS);
            nbt.func_82580_o(TAG_HIDE_FLAGS);
        }
    }

    public static int getLootingLevel(IModifierToolStack tool, LivingEntity holder, Entity target, @Nullable DamageSource damageSource) {
        if (tool.isBroken()) {
            return 0;
        }
        int looting = 0;
        for (ModifierEntry entry : tool.getModifierList()) {
            looting = entry.getModifier().getLootingValue(tool, entry.getLevel(), holder, target, damageSource, looting);
        }
        return looting;
    }

    public static void dropItem(Entity target, ItemStack stack) {
        World world = target.func_130014_f_();
        if (!stack.func_190926_b() && !target.func_130014_f_().func_201670_d()) {
            ItemEntity ent = new ItemEntity(world, target.func_226277_ct_(), target.func_226278_cu_() + 1.0, target.func_226281_cx_(), stack);
            ent.func_174869_p();
            Random rand = target.field_70170_p.field_73012_v;
            ent.func_213317_d(ent.func_213322_ci().func_72441_c((double)((rand.nextFloat() - rand.nextFloat()) * 0.1f), (double)(rand.nextFloat() * 0.05f), (double)((rand.nextFloat() - rand.nextFloat()) * 0.1f)));
            world.func_217376_c((Entity)ent);
        }
    }

    private ModifierUtil() {
    }
}

