/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.tools.helper;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.CampfireBlock;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SChangeBlockPacket;
import net.minecraft.state.Property;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.GameType;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.ToolType;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.common.network.TinkerNetwork;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.tools.context.ToolHarvestContext;
import slimeknights.tconstruct.library.tools.helper.ModifierUtil;
import slimeknights.tconstruct.library.tools.helper.ToolDamageUtil;
import slimeknights.tconstruct.library.tools.nbt.IModifierToolStack;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;
import slimeknights.tconstruct.library.tools.stat.ToolStats;
import slimeknights.tconstruct.library.utils.BlockSideHitListener;

public class ToolHarvestLogic {
    public static final ToolHarvestLogic DEFAULT = new ToolHarvestLogic();

    public int getDamage(ToolStack tool, ItemStack stack, World world, BlockPos pos, BlockState state) {
        if (state.func_185887_b((IBlockReader)world, pos) == 0.0f) {
            return 0;
        }
        return tool.getItem().func_206844_a(TinkerTags.Items.HARVEST_PRIMARY) ? 1 : 2;
    }

    public boolean isEffectiveAgainst(IModifierToolStack tool, ItemStack stack, BlockState state) {
        return stack.getToolTypes().stream().anyMatch(arg_0 -> ((BlockState)state).isToolEffective(arg_0));
    }

    public final boolean isEffective(IModifierToolStack tool, ItemStack stack, BlockState state) {
        if (tool.isBroken()) {
            return false;
        }
        if (state.func_235783_q_() && tool.getStats().getInt(ToolStats.HARVEST_LEVEL) < state.getHarvestLevel()) {
            return false;
        }
        return this.isEffectiveAgainst(tool, stack, state);
    }

    public float getDestroySpeed(ItemStack stack, BlockState blockState) {
        if (!stack.func_77942_o()) {
            return 1.0f;
        }
        ToolStack tool = ToolStack.from(stack);
        if (tool.isBroken()) {
            return 0.3f;
        }
        if (!this.isEffective(tool, stack, blockState)) {
            return 1.0f;
        }
        return tool.getStats().getFloat(ToolStats.MINING_SPEED);
    }

    public Iterable<BlockPos> getAOEBlocks(IModifierToolStack tool, ItemStack stack, PlayerEntity player, BlockState state, World world, BlockPos origin, Direction sideHit, AOEMatchType matchType) {
        return Collections.emptyList();
    }

    private boolean removeBlock(IModifierToolStack tool, ToolHarvestContext context) {
        Boolean removed = null;
        if (!tool.isBroken()) {
            ModifierEntry entry;
            Iterator<ModifierEntry> iterator = tool.getModifierList().iterator();
            while (iterator.hasNext() && (removed = (entry = iterator.next()).getModifier().removeBlock(tool, entry.getLevel(), context)) == null) {
            }
        }
        BlockState state = context.getState();
        ServerWorld world = context.getWorld();
        BlockPos pos = context.getPos();
        if (removed == null) {
            removed = state.removedByPlayer((World)world, pos, (PlayerEntity)context.getPlayer(), context.canHarvest(), world.func_204610_c(pos));
        }
        if (removed.booleanValue()) {
            state.func_177230_c().func_176206_d((IWorld)world, pos, state);
        }
        return removed;
    }

    protected boolean breakBlock(ToolStack tool, ItemStack stack, ToolHarvestContext context) {
        ServerPlayerEntity player = Objects.requireNonNull(context.getPlayer());
        ServerWorld world = context.getWorld();
        BlockPos pos = context.getPos();
        GameType type = player.field_71134_c.func_73081_b();
        int exp = ForgeHooks.onBlockBreakEvent((World)world, (GameType)type, (ServerPlayerEntity)player, (BlockPos)pos);
        if (exp == -1) {
            return false;
        }
        if (player.func_223729_a((World)world, pos, type)) {
            return false;
        }
        if (player.func_184812_l_()) {
            this.removeBlock(tool, context);
            return true;
        }
        BlockState state = context.getState();
        int damage = this.getDamage(tool, stack, (World)world, pos, state);
        boolean canHarvest = context.canHarvest();
        TileEntity te = canHarvest ? world.func_175625_s(pos) : null;
        boolean removed = this.removeBlock(tool, context);
        Block block = state.func_177230_c();
        if (removed && canHarvest) {
            block.func_180657_a((World)world, (PlayerEntity)player, pos, state, te, stack);
        }
        if (removed && exp > 0) {
            state.func_177230_c().func_180637_b(world, pos, exp);
        }
        if (!tool.isBroken()) {
            for (ModifierEntry entry : tool.getModifierList()) {
                entry.getModifier().afterBlockBreak(tool, entry.getLevel(), context);
            }
            ToolDamageUtil.damageAnimated(tool, damage, (LivingEntity)player);
        }
        return true;
    }

    public void breakExtraBlock(ToolStack tool, ItemStack stack, ToolHarvestContext context) {
        if (this.breakBlock(tool, stack, context)) {
            ServerWorld world = context.getWorld();
            BlockPos pos = context.getPos();
            world.func_217379_c(2001, pos, Block.func_196246_j((BlockState)context.getState()));
            TinkerNetwork.getInstance().sendVanillaPacket((Entity)Objects.requireNonNull(context.getPlayer()), (IPacket<?>)new SChangeBlockPacket((IBlockReader)world, pos));
        }
    }

    public boolean handleBlockBreak(ItemStack stack, BlockPos pos, PlayerEntity player) {
        if (player.func_130014_f_().field_72995_K || !(player instanceof ServerPlayerEntity)) {
            return false;
        }
        ServerPlayerEntity serverPlayer = (ServerPlayerEntity)player;
        ServerWorld world = serverPlayer.func_71121_q();
        ToolStack tool = ToolStack.from(stack);
        BlockState state = world.func_180495_p(pos);
        Direction sideHit = BlockSideHitListener.getSideHit(player);
        if (tool.isBroken()) {
            ToolHarvestContext context = new ToolHarvestContext(world, serverPlayer, state, pos, sideHit, false, false);
            player.func_184611_a(Hand.MAIN_HAND, ItemStack.field_190927_a);
            this.breakBlock(tool, ItemStack.field_190927_a, context);
            player.func_184611_a(Hand.MAIN_HAND, stack);
        } else {
            List<BlockPos> extraBlocks;
            ToolHarvestContext context = new ToolHarvestContext(world, serverPlayer, state, pos, sideHit, !player.func_184812_l_() && state.canHarvestBlock((IBlockReader)world, pos, player), this.isEffective(tool, stack, state));
            boolean addedEnchants = ModifierUtil.applyHarvestEnchants(tool, stack, context);
            Iterable<BlockPos> iterable = extraBlocks = context.isEffective() ? this.getAOEBlocks(tool, stack, player, state, (World)world, pos, sideHit, AOEMatchType.BREAKING) : Collections.emptyList();
            if (this.breakBlock(tool, stack, context)) {
                for (BlockPos extraPos : extraBlocks) {
                    BlockState extraState = world.func_180495_p(extraPos);
                    if (extraState.isAir((IBlockReader)world, extraPos)) continue;
                    this.breakExtraBlock(tool, stack, context.forPosition(extraPos.func_185334_h(), extraState));
                }
                for (ModifierEntry entry : tool.getModifierList()) {
                    entry.getModifier().finishBreakingBlocks(tool, entry.getLevel(), context);
                }
            }
            if (addedEnchants) {
                ModifierUtil.clearEnchantments(stack);
            }
        }
        return true;
    }

    public ActionResultType transformBlocks(IModifierToolStack tool, ItemUseContext context, ToolType toolType, SoundEvent sound, boolean requireGround) {
        boolean didTransform;
        PlayerEntity player = context.func_195999_j();
        if (player != null && player.func_225608_bj_()) {
            return ActionResultType.PASS;
        }
        World world = context.func_195991_k();
        BlockPos pos = context.func_195995_a();
        if (requireGround) {
            if (context.func_196000_l() == Direction.DOWN) {
                return ActionResultType.PASS;
            }
            Material material = world.func_180495_p(pos.func_177984_a()).func_185904_a();
            if (!material.func_76222_j() && material != Material.field_151585_k) {
                return ActionResultType.PASS;
            }
        }
        BlockState original = world.func_180495_p(pos);
        ItemStack stack = context.func_195996_i();
        BlockState transformed = original.getToolModifiedState(world, pos, player, stack, toolType);
        boolean isCampfire = false;
        boolean bl = didTransform = transformed != null;
        if (transformed == null) {
            if (toolType == ToolType.SHOVEL && original.func_177230_c() instanceof CampfireBlock && ((Boolean)original.func_177229_b((Property)CampfireBlock.field_220101_b)).booleanValue()) {
                isCampfire = true;
                if (!world.func_201670_d()) {
                    world.func_217378_a(null, 1009, pos, 0);
                    CampfireBlock.func_235475_c_((IWorld)world, (BlockPos)pos, (BlockState)original);
                }
                transformed = (BlockState)original.func_206870_a((Property)CampfireBlock.field_220101_b, (Comparable)Boolean.valueOf(false));
            } else {
                transformed = world.func_180495_p(pos);
            }
        }
        Hand hand = context.func_221531_n();
        if (didTransform || isCampfire) {
            if (world.func_201670_d()) {
                return ActionResultType.SUCCESS;
            }
            world.func_180501_a(pos, transformed, 11);
            if (requireGround) {
                world.func_175655_b(pos.func_177984_a(), true);
            }
            if (!isCampfire) {
                world.func_184133_a(null, pos, sound, SoundCategory.BLOCKS, 1.0f, 1.0f);
            }
            if (ToolDamageUtil.damage(tool, 1, (LivingEntity)player, stack) || isCampfire) {
                if (player != null) {
                    player.func_213334_d(hand);
                }
                return ActionResultType.SUCCESS;
            }
        }
        int totalTransformed = 0;
        if (player != null && !tool.isBroken()) {
            for (BlockPos newPos : this.getAOEBlocks(tool, stack, player, original, world, pos, context.func_196000_l(), AOEMatchType.TRANSFORM)) {
                BlockState newState;
                Material material;
                if (pos.equals((Object)newPos)) continue;
                BlockPos above = newPos.func_177984_a();
                if (requireGround && !(material = world.func_180495_p(above).func_185904_a()).func_76222_j() && material != Material.field_151585_k || (newState = world.func_180495_p(newPos).getToolModifiedState(world, newPos, player, stack, toolType)) == null || transformed.func_177230_c() != newState.func_177230_c()) continue;
                if (world.func_201670_d()) {
                    return ActionResultType.SUCCESS;
                }
                world.func_180501_a(newPos, newState, 11);
                if (++totalTransformed < 40) {
                    world.func_184133_a(null, newPos, sound, SoundCategory.BLOCKS, 1.0f, 1.0f);
                }
                if (requireGround) {
                    world.func_175655_b(above, true);
                }
                if (!ToolDamageUtil.damageAnimated(tool, 1, (LivingEntity)player, hand)) continue;
                break;
            }
            if (totalTransformed > 0) {
                player.func_184810_cG();
            }
        }
        return didTransform || totalTransformed > 0 ? ActionResultType.SUCCESS : ActionResultType.PASS;
    }

    public static Predicate<BlockPos> getDefaultBlockPredicate(ToolHarvestLogic self, IModifierToolStack tool, ItemStack stack, World world, BlockPos origin, AOEMatchType matchType) {
        if (matchType == AOEMatchType.BREAKING) {
            float refHardness = world.func_180495_p(origin).func_185887_b((IBlockReader)world, origin);
            return pos -> {
                BlockState state = world.func_180495_p(pos);
                if (state.isAir((IBlockReader)world, pos)) {
                    return false;
                }
                float hardness = state.func_185887_b((IBlockReader)world, pos);
                if (hardness == -1.0f) {
                    return false;
                }
                if (refHardness == 0.0f ? hardness == 0.0f : hardness / refHardness <= 3.0f) {
                    return self.isEffective(tool, stack, state);
                }
                return false;
            };
        }
        return pos -> !world.func_180495_p(pos).isAir((IBlockReader)world, pos);
    }

    public static enum AOEMatchType {
        BREAKING,
        TRANSFORM;

    }
}

