/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.tools.helper.aoe;

import com.google.common.collect.AbstractIterator;
import java.util.ArrayDeque;
import java.util.HashSet;
import java.util.Queue;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.tools.helper.ToolHarvestLogic;
import slimeknights.tconstruct.library.tools.nbt.IModifierToolStack;
import slimeknights.tconstruct.tools.TinkerModifiers;

public class VeiningAOEHarvestLogic
extends ToolHarvestLogic {
    public static final VeiningAOEHarvestLogic SMALL = new VeiningAOEHarvestLogic(0);
    private final int maxDistance;

    @Override
    public Iterable<BlockPos> getAOEBlocks(IModifierToolStack tool, ItemStack stack, PlayerEntity player, BlockState state, World world, BlockPos origin, Direction sideHit, ToolHarvestLogic.AOEMatchType matchType) {
        int expanded = tool.getModifierLevel((Modifier)TinkerModifiers.expanded.get());
        return VeiningAOEHarvestLogic.calculate(state, world, origin, this.maxDistance + expanded);
    }

    public static Iterable<BlockPos> calculate(BlockState state, World world, BlockPos origin, int maxDistance) {
        return () -> new VeiningIterator(world, origin, state.func_177230_c(), maxDistance);
    }

    public VeiningAOEHarvestLogic(int maxDistance) {
        this.maxDistance = maxDistance;
    }

    private static class DistancePos {
        private final BlockPos pos;
        private final int distance;

        public DistancePos(BlockPos pos, int distance) {
            this.pos = pos;
            this.distance = distance;
        }

        public BlockPos getPos() {
            return this.pos;
        }

        public int getDistance() {
            return this.distance;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof DistancePos)) {
                return false;
            }
            DistancePos other = (DistancePos)o;
            if (!other.canEqual(this)) {
                return false;
            }
            BlockPos this$pos = this.getPos();
            BlockPos other$pos = other.getPos();
            if (this$pos == null ? other$pos != null : !this$pos.equals(other$pos)) {
                return false;
            }
            return this.getDistance() == other.getDistance();
        }

        protected boolean canEqual(Object other) {
            return other instanceof DistancePos;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            BlockPos $pos = this.getPos();
            result = result * 59 + ($pos == null ? 43 : $pos.hashCode());
            result = result * 59 + this.getDistance();
            return result;
        }

        public String toString() {
            return "VeiningAOEHarvestLogic.DistancePos(pos=" + this.getPos() + ", distance=" + this.getDistance() + ")";
        }
    }

    private static class VeiningIterator
    extends AbstractIterator<BlockPos> {
        private final Set<BlockPos> visited = new HashSet<BlockPos>();
        private final Queue<DistancePos> queue = new ArrayDeque<DistancePos>();
        private final World world;
        private final Block target;
        private final int maxDistance;

        private VeiningIterator(World world, BlockPos origin, Block target, int maxDistance) {
            this.world = world;
            this.target = target;
            this.maxDistance = maxDistance;
            this.visited.add(origin);
            if (maxDistance > 0) {
                this.enqueueNeighbors(origin, 1);
            }
        }

        private void enqueueNeighbors(BlockPos pos, int distance) {
            for (Direction direction : Direction.values()) {
                BlockPos offset = pos.func_177972_a(direction);
                if (this.visited.contains(offset)) continue;
                this.visited.add(offset);
                this.queue.add(new DistancePos(offset, distance));
            }
        }

        protected BlockPos computeNext() {
            while (!this.queue.isEmpty()) {
                DistancePos distancePos = this.queue.remove();
                BlockPos pos = distancePos.getPos();
                if (!this.world.func_180495_p(pos).func_203425_a(this.target)) continue;
                int distance = distancePos.getDistance();
                if (distance < this.maxDistance) {
                    this.enqueueNeighbors(pos, distance + 1);
                }
                return pos;
            }
            return (BlockPos)this.endOfData();
        }
    }
}

