/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.plugin.jei.entity;

import java.util.Collection;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.ingredient.IGuiIngredientGroup;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.recipe.IFocus;
import net.minecraft.entity.EntityType;
import net.minecraft.item.ItemStack;
import net.minecraft.item.SpawnEggItem;
import net.minecraft.util.ResourceLocation;

public class EntityIngredientHelper
implements IIngredientHelper<EntityType> {
    @Nullable
    public EntityType getMatch(Iterable<EntityType> iterable, EntityType type) {
        for (EntityType match : iterable) {
            if (match != type) continue;
            return match;
        }
        return null;
    }

    public String getDisplayName(EntityType type) {
        return type.func_212546_e().getString();
    }

    public String getUniqueId(EntityType type) {
        return Objects.requireNonNull(type.getRegistryName()).toString();
    }

    public String getWildcardId(EntityType type) {
        return this.getUniqueId(type);
    }

    public String getModId(EntityType type) {
        return Objects.requireNonNull(type.getRegistryName()).func_110624_b();
    }

    public String getResourceId(EntityType type) {
        return Objects.requireNonNull(type.getRegistryName()).func_110623_a();
    }

    public EntityType copyIngredient(EntityType type) {
        return type;
    }

    public String getErrorInfo(@Nullable EntityType type) {
        if (type == null) {
            return "null";
        }
        ResourceLocation name = type.getRegistryName();
        if (name == null) {
            return "unnamed sadface :(";
        }
        return name.toString();
    }

    public static void setFocus(IRecipeLayout layout, IGuiIngredientGroup<EntityType> group, Collection<EntityType<?>> entities, int index) {
        IFocus focus = layout.getFocus(VanillaTypes.ITEM);
        if (focus != null && ((ItemStack)focus.getValue()).func_77973_b() instanceof SpawnEggItem) {
            EntityType type = ((SpawnEggItem)((ItemStack)focus.getValue()).func_77973_b()).func_208076_b(null);
            group.set(index, entities.stream().filter(type::equals).collect(Collectors.toList()));
        }
    }
}

