/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.shared;

import java.util.function.Supplier;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.advancements.ICriterionTrigger;
import net.minecraft.block.Block;
import net.minecraft.block.GlassBlock;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.IDataProvider;
import net.minecraft.item.Item;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.loot.ILootSerializer;
import net.minecraft.loot.LootConditionType;
import net.minecraft.loot.LootFunctionType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.ToolType;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.conditions.IConditionSerializer;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.GatherDataEvent;
import org.apache.logging.log4j.Logger;
import slimeknights.mantle.item.EdibleItem;
import slimeknights.mantle.registration.object.BuildingBlockObject;
import slimeknights.mantle.registration.object.EnumObject;
import slimeknights.mantle.registration.object.ItemObject;
import slimeknights.tconstruct.common.TinkerModule;
import slimeknights.tconstruct.common.data.FluidTagEmptyCondition;
import slimeknights.tconstruct.common.json.ConfigEnabledCondition;
import slimeknights.tconstruct.common.json.SetFluidLootFunction;
import slimeknights.tconstruct.common.recipe.BlockOrEntityCondition;
import slimeknights.tconstruct.common.recipe.RecipeCacheInvalidator;
import slimeknights.tconstruct.library.utils.Util;
import slimeknights.tconstruct.shared.TinkerFood;
import slimeknights.tconstruct.shared.block.BetterPaneBlock;
import slimeknights.tconstruct.shared.block.ClearGlassPaneBlock;
import slimeknights.tconstruct.shared.block.ClearStainedGlassBlock;
import slimeknights.tconstruct.shared.block.ClearStainedGlassPaneBlock;
import slimeknights.tconstruct.shared.block.GlowBlock;
import slimeknights.tconstruct.shared.block.SlimeType;
import slimeknights.tconstruct.shared.command.TConstructCommand;
import slimeknights.tconstruct.shared.data.CommonRecipeProvider;
import slimeknights.tconstruct.shared.inventory.BlockContainerOpenedTrigger;
import slimeknights.tconstruct.shared.item.TinkerBookItem;

public final class TinkerCommons
extends TinkerModule {
    static final Logger log = Util.getLogger("tinker_commons");
    public static final Material GLOW = new Material.Builder(MaterialColor.field_151660_b).func_200508_c().func_200505_j().func_200502_b().func_200511_g().func_200509_f().func_200506_i();
    public static final RegistryObject<GlowBlock> glow = BLOCKS.registerNoItem("glow", () -> new GlowBlock(TinkerCommons.builder(GLOW, NO_TOOL, SoundType.field_185854_g).func_200943_b(0.0f).func_235838_a_(s -> 14).func_226896_b_()));
    public static final BuildingBlockObject mudBricks = BLOCKS.registerBuilding("mud_bricks", TinkerCommons.builder(Material.field_151578_c, ToolType.SHOVEL, SoundType.field_185849_b).func_235861_h_().func_200943_b(2.0f), GENERAL_BLOCK_ITEM);
    public static final ItemObject<GlassBlock> clearGlass = BLOCKS.register("clear_glass", () -> new GlassBlock(TinkerCommons.glassBuilder(MaterialColor.field_151660_b)), GENERAL_BLOCK_ITEM);
    public static final ItemObject<ClearGlassPaneBlock> clearGlassPane = BLOCKS.register("clear_glass_pane", () -> new ClearGlassPaneBlock(TinkerCommons.glassBuilder(MaterialColor.field_151660_b)), GENERAL_BLOCK_ITEM);
    public static final EnumObject<ClearStainedGlassBlock.GlassColor, ClearStainedGlassBlock> clearStainedGlass = BLOCKS.registerEnum(ClearStainedGlassBlock.GlassColor.values(), "clear_stained_glass", color -> new ClearStainedGlassBlock(TinkerCommons.glassBuilder(color.getDye().func_196055_e()), (ClearStainedGlassBlock.GlassColor)((Object)color)), GENERAL_BLOCK_ITEM);
    public static final EnumObject<ClearStainedGlassBlock.GlassColor, ClearStainedGlassPaneBlock> clearStainedGlassPane = BLOCKS.registerEnum(ClearStainedGlassBlock.GlassColor.values(), "clear_stained_glass_pane", color -> new ClearStainedGlassPaneBlock(TinkerCommons.glassBuilder(color.getDye().func_196055_e()), (ClearStainedGlassBlock.GlassColor)((Object)color)), GENERAL_BLOCK_ITEM);
    public static final ItemObject<GlassBlock> soulGlass = BLOCKS.register("soul_glass", () -> new GlassBlock(TinkerCommons.glassBuilder(MaterialColor.field_151650_B)), GENERAL_BLOCK_ITEM);
    public static final ItemObject<ClearGlassPaneBlock> soulGlassPane = BLOCKS.register("soul_glass_pane", () -> new ClearGlassPaneBlock(TinkerCommons.glassBuilder(MaterialColor.field_151650_B)), GENERAL_BLOCK_ITEM);
    public static final BuildingBlockObject lavawood = BLOCKS.registerBuilding("lavawood", TinkerCommons.woodBuilder(MaterialColor.field_151676_q).func_235838_a_(s -> 7), GENERAL_BLOCK_ITEM);
    public static final BuildingBlockObject blazewood = BLOCKS.registerBuilding("blazewood", TinkerCommons.woodBuilder(MaterialColor.field_193559_aa).func_235838_a_(s -> 7), GENERAL_BLOCK_ITEM);
    public static final ItemObject<Block> obsidianPane = BLOCKS.register("obsidian_pane", () -> new BetterPaneBlock(TinkerCommons.builder(Material.field_151576_e, MaterialColor.field_151654_J, ToolType.PICKAXE, SoundType.field_185851_d).func_235861_h_().func_226896_b_().func_200948_a(25.0f, 400.0f)), GENERAL_BLOCK_ITEM);
    public static final ItemObject<EdibleItem> bacon = ITEMS.register("bacon", () -> new EdibleItem(TinkerFood.BACON, TAB_GENERAL));
    private static final Item.Properties BOOK = new Item.Properties().func_200916_a(TAB_GENERAL).func_200917_a(1);
    public static final ItemObject<TinkerBookItem> materialsAndYou = ITEMS.register("materials_and_you", () -> new TinkerBookItem(BOOK, TinkerBookItem.BookType.MATERIALS_AND_YOU));
    public static final ItemObject<TinkerBookItem> punySmelting = ITEMS.register("puny_smelting", () -> new TinkerBookItem(BOOK, TinkerBookItem.BookType.PUNY_SMELTING));
    public static final ItemObject<TinkerBookItem> mightySmelting = ITEMS.register("mighty_smelting", () -> new TinkerBookItem(BOOK, TinkerBookItem.BookType.MIGHTY_SMELTING));
    public static final ItemObject<TinkerBookItem> tinkersGadgetry = ITEMS.register("tinkers_gadgetry", () -> new TinkerBookItem(BOOK, TinkerBookItem.BookType.TINKERS_GADGETRY));
    public static final ItemObject<TinkerBookItem> fantasticFoundry = ITEMS.register("fantastic_foundry", () -> new TinkerBookItem(BOOK, TinkerBookItem.BookType.FANTASTIC_FOUNDRY));
    public static final ItemObject<TinkerBookItem> encyclopedia = ITEMS.register("encyclopedia", () -> new TinkerBookItem(BOOK, TinkerBookItem.BookType.ENCYCLOPEDIA));
    public static LootConditionType lootConfig;
    public static LootConditionType lootBlockOrEntity;
    public static LootFunctionType lootSetFluid;
    public static final EnumObject<SlimeType, Item> slimeball;
    public static final BlockContainerOpenedTrigger CONTAINER_OPENED_TRIGGER;

    public TinkerCommons() {
        MinecraftForge.EVENT_BUS.addListener(RecipeCacheInvalidator::onReloadListenerReload);
    }

    @SubscribeEvent
    void commonSetupEvent(FMLCommonSetupEvent event) {
        TConstructCommand.init();
    }

    @SubscribeEvent
    void registerRecipeSerializers(RegistryEvent.Register<IRecipeSerializer<?>> event) {
        CraftingHelper.register((IConditionSerializer)ConfigEnabledCondition.SERIALIZER);
        CraftingHelper.register((IConditionSerializer)FluidTagEmptyCondition.SERIALIZER);
        lootConfig = (LootConditionType)Registry.func_218322_a((Registry)Registry.field_239704_ba_, (ResourceLocation)ConfigEnabledCondition.ID, (Object)new LootConditionType((ILootSerializer)ConfigEnabledCondition.SERIALIZER));
        lootBlockOrEntity = (LootConditionType)Registry.func_218322_a((Registry)Registry.field_239704_ba_, (ResourceLocation)BlockOrEntityCondition.ID, (Object)new LootConditionType((ILootSerializer)BlockOrEntityCondition.SERIALIZER));
        lootSetFluid = (LootFunctionType)Registry.func_218322_a((Registry)Registry.field_239694_aZ_, (ResourceLocation)SetFluidLootFunction.ID, (Object)new LootFunctionType((ILootSerializer)new SetFluidLootFunction.Serializer()));
        CriteriaTriggers.func_192118_a((ICriterionTrigger)CONTAINER_OPENED_TRIGGER);
    }

    @SubscribeEvent
    void gatherData(GatherDataEvent event) {
        if (event.includeServer()) {
            DataGenerator datagenerator = event.getGenerator();
            datagenerator.func_200390_a((IDataProvider)new CommonRecipeProvider(datagenerator));
        }
    }

    static {
        slimeball = new EnumObject.Builder(SlimeType.class).put((Enum)SlimeType.EARTH, (Supplier)Items.field_151123_aH.delegate).putAll(ITEMS.registerEnum(SlimeType.TINKER, "slime_ball", type -> new Item(GENERAL_PROPS))).build();
        CONTAINER_OPENED_TRIGGER = new BlockContainerOpenedTrigger();
    }
}

